/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.Assert;
import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.PublicApi;
import graphql.execution.DataFetcherResult;
import graphql.execution.ExecutionPath;
import graphql.language.SourceLocation;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@PublicApi
public class GraphqlErrorBuilder {
    private String message;
    private List<Object> path;
    private List<SourceLocation> locations = new ArrayList<SourceLocation>();
    private ErrorClassification errorType = ErrorType.DataFetchingException;
    private Map<String, Object> extensions = null;

    public static GraphqlErrorBuilder newError() {
        return new GraphqlErrorBuilder();
    }

    public static GraphqlErrorBuilder newError(DataFetchingEnvironment dataFetchingEnvironment) {
        return new GraphqlErrorBuilder().location(dataFetchingEnvironment.getField().getSourceLocation()).path(dataFetchingEnvironment.getExecutionStepInfo().getPath());
    }

    private GraphqlErrorBuilder() {
    }

    public GraphqlErrorBuilder message(String message, Object ... formatArgs) {
        this.message = formatArgs == null || formatArgs.length == 0 ? Assert.assertNotNull(message) : String.format(Assert.assertNotNull(message), formatArgs);
        return this;
    }

    public GraphqlErrorBuilder locations(List<SourceLocation> locations) {
        this.locations.addAll((Collection<SourceLocation>)Assert.assertNotNull(locations));
        return this;
    }

    public GraphqlErrorBuilder location(SourceLocation location) {
        this.locations.add(Assert.assertNotNull(location));
        return this;
    }

    public GraphqlErrorBuilder path(ExecutionPath path) {
        this.path = Assert.assertNotNull(path).toList();
        return this;
    }

    public GraphqlErrorBuilder path(List<Object> path) {
        this.path = Assert.assertNotNull(path);
        return this;
    }

    public GraphqlErrorBuilder errorType(ErrorClassification errorType) {
        this.errorType = Assert.assertNotNull(errorType);
        return this;
    }

    public GraphqlErrorBuilder extensions(Map<String, Object> extensions) {
        this.extensions = Assert.assertNotNull(extensions);
        return this;
    }

    public GraphQLError build() {
        Assert.assertNotNull(this.message, "You must provide error message", new Object[0]);
        return new GraphqlErrorImpl(this.message, this.locations, this.errorType, this.path, this.extensions);
    }

    public DataFetcherResult toResult() {
        return DataFetcherResult.newResult().error(this.build()).build();
    }

    private static class GraphqlErrorImpl
    implements GraphQLError {
        private final String message;
        private final List<SourceLocation> locations;
        private final ErrorClassification errorType;
        private final List<Object> path;
        private final Map<String, Object> extensions;

        public GraphqlErrorImpl(String message, List<SourceLocation> locations, ErrorClassification errorType, List<Object> path, Map<String, Object> extensions) {
            this.message = message;
            this.locations = locations;
            this.errorType = errorType;
            this.path = path;
            this.extensions = extensions;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public List<SourceLocation> getLocations() {
            return this.locations;
        }

        @Override
        public ErrorClassification getErrorType() {
            return this.errorType;
        }

        @Override
        public List<Object> getPath() {
            return this.path;
        }

        @Override
        public Map<String, Object> getExtensions() {
            return this.extensions;
        }
    }
}

