/*
 * Decompiled with CFR 0.152.
 */
package graphql.parser;

import graphql.Assert;
import graphql.Internal;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.Comment;
import graphql.language.Definition;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectiveLocation;
import graphql.language.Document;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumTypeExtensionDefinition;
import graphql.language.EnumValue;
import graphql.language.EnumValueDefinition;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.language.FloatValue;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.IgnoredChar;
import graphql.language.IgnoredChars;
import graphql.language.InlineFragment;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputObjectTypeExtensionDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.IntValue;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.InterfaceTypeExtensionDefinition;
import graphql.language.ListType;
import graphql.language.NodeBuilder;
import graphql.language.NonNullType;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.ScalarTypeExtensionDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.SchemaExtensionDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.SourceLocation;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.UnionTypeExtensionDefinition;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.parser.AntlrHelper;
import graphql.parser.MultiSourceReader;
import graphql.parser.StringValueParsing;
import graphql.parser.antlr.GraphqlLexer;
import graphql.parser.antlr.GraphqlParser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;

@Internal
public class GraphqlAntlrToLanguage {
    private static final int CHANNEL_COMMENTS = 2;
    private static final int CHANNEL_IGNORED_CHARS = 3;
    private final CommonTokenStream tokens;
    private final MultiSourceReader multiSourceReader;

    public GraphqlAntlrToLanguage(CommonTokenStream tokens, MultiSourceReader multiSourceReader) {
        this.tokens = tokens;
        this.multiSourceReader = multiSourceReader;
    }

    public Document createDocument(GraphqlParser.DocumentContext ctx) {
        Document.Builder document = Document.newDocument();
        this.addCommonData(document, ctx);
        document.definitions(ctx.definition().stream().map(this::createDefinition).collect(Collectors.toList()));
        return document.build();
    }

    protected Definition createDefinition(GraphqlParser.DefinitionContext definitionContext) {
        if (definitionContext.operationDefinition() != null) {
            return this.createOperationDefinition(definitionContext.operationDefinition());
        }
        if (definitionContext.fragmentDefinition() != null) {
            return this.createFragmentDefinition(definitionContext.fragmentDefinition());
        }
        if (definitionContext.typeSystemDefinition() != null) {
            return this.createTypeSystemDefinition(definitionContext.typeSystemDefinition());
        }
        if (definitionContext.typeSystemExtension() != null) {
            return this.createTypeSystemExtension(definitionContext.typeSystemExtension());
        }
        return (Definition)Assert.assertShouldNeverHappen();
    }

    protected OperationDefinition createOperationDefinition(GraphqlParser.OperationDefinitionContext ctx) {
        OperationDefinition.Builder operationDefinition = OperationDefinition.newOperationDefinition();
        this.addCommonData(operationDefinition, ctx);
        if (ctx.operationType() == null) {
            operationDefinition.operation(OperationDefinition.Operation.QUERY);
        } else {
            operationDefinition.operation(this.parseOperation(ctx.operationType()));
        }
        if (ctx.name() != null) {
            operationDefinition.name(ctx.name().getText());
        }
        operationDefinition.variableDefinitions(this.createVariableDefinitions(ctx.variableDefinitions()));
        operationDefinition.selectionSet(this.createSelectionSet(ctx.selectionSet()));
        operationDefinition.directives(this.createDirectives(ctx.directives()));
        return operationDefinition.build();
    }

    protected OperationDefinition.Operation parseOperation(GraphqlParser.OperationTypeContext operationTypeContext) {
        switch (operationTypeContext.getText()) {
            case "query": {
                return OperationDefinition.Operation.QUERY;
            }
            case "mutation": {
                return OperationDefinition.Operation.MUTATION;
            }
            case "subscription": {
                return OperationDefinition.Operation.SUBSCRIPTION;
            }
        }
        return (OperationDefinition.Operation)((Object)Assert.assertShouldNeverHappen("InternalError: unknown operationTypeContext=%s", operationTypeContext.getText()));
    }

    protected FragmentSpread createFragmentSpread(GraphqlParser.FragmentSpreadContext ctx) {
        FragmentSpread.Builder fragmentSpread = FragmentSpread.newFragmentSpread().name(ctx.fragmentName().getText());
        this.addCommonData(fragmentSpread, ctx);
        fragmentSpread.directives(this.createDirectives(ctx.directives()));
        return fragmentSpread.build();
    }

    protected List<VariableDefinition> createVariableDefinitions(GraphqlParser.VariableDefinitionsContext ctx) {
        if (ctx == null) {
            return new ArrayList<VariableDefinition>();
        }
        return ctx.variableDefinition().stream().map(this::createVariableDefinition).collect(Collectors.toList());
    }

    protected VariableDefinition createVariableDefinition(GraphqlParser.VariableDefinitionContext ctx) {
        VariableDefinition.Builder variableDefinition = VariableDefinition.newVariableDefinition();
        this.addCommonData(variableDefinition, ctx);
        variableDefinition.name(ctx.variable().name().getText());
        if (ctx.defaultValue() != null) {
            Value value = this.createValue(ctx.defaultValue().value());
            variableDefinition.defaultValue(value);
        }
        variableDefinition.type(this.createType(ctx.type()));
        return variableDefinition.build();
    }

    protected FragmentDefinition createFragmentDefinition(GraphqlParser.FragmentDefinitionContext ctx) {
        FragmentDefinition.Builder fragmentDefinition = FragmentDefinition.newFragmentDefinition();
        this.addCommonData(fragmentDefinition, ctx);
        fragmentDefinition.name(ctx.fragmentName().getText());
        fragmentDefinition.typeCondition(TypeName.newTypeName().name(ctx.typeCondition().typeName().getText()).build());
        fragmentDefinition.directives(this.createDirectives(ctx.directives()));
        fragmentDefinition.selectionSet(this.createSelectionSet(ctx.selectionSet()));
        return fragmentDefinition.build();
    }

    protected SelectionSet createSelectionSet(GraphqlParser.SelectionSetContext ctx) {
        if (ctx == null) {
            return null;
        }
        SelectionSet.Builder builder = SelectionSet.newSelectionSet();
        this.addCommonData(builder, ctx);
        List selections = ctx.selection().stream().map(selectionContext -> {
            if (selectionContext.field() != null) {
                return this.createField(selectionContext.field());
            }
            if (selectionContext.fragmentSpread() != null) {
                return this.createFragmentSpread(selectionContext.fragmentSpread());
            }
            if (selectionContext.inlineFragment() != null) {
                return this.createInlineFragment(selectionContext.inlineFragment());
            }
            return (Selection)Assert.assertShouldNeverHappen();
        }).collect(Collectors.toList());
        builder.selections(selections);
        return builder.build();
    }

    protected Field createField(GraphqlParser.FieldContext ctx) {
        Field.Builder builder = Field.newField();
        this.addCommonData(builder, ctx);
        builder.name(ctx.name().getText());
        if (ctx.alias() != null) {
            builder.alias(ctx.alias().name().getText());
        }
        builder.directives(this.createDirectives(ctx.directives()));
        builder.arguments(this.createArguments(ctx.arguments()));
        builder.selectionSet(this.createSelectionSet(ctx.selectionSet()));
        return builder.build();
    }

    protected InlineFragment createInlineFragment(GraphqlParser.InlineFragmentContext ctx) {
        InlineFragment.Builder inlineFragment = InlineFragment.newInlineFragment();
        this.addCommonData(inlineFragment, ctx);
        if (ctx.typeCondition() != null) {
            inlineFragment.typeCondition(this.createTypeName(ctx.typeCondition().typeName()));
        }
        inlineFragment.directives(this.createDirectives(ctx.directives()));
        inlineFragment.selectionSet(this.createSelectionSet(ctx.selectionSet()));
        return inlineFragment.build();
    }

    protected SDLDefinition createTypeSystemDefinition(GraphqlParser.TypeSystemDefinitionContext ctx) {
        if (ctx.schemaDefinition() != null) {
            return this.createSchemaDefinition(ctx.schemaDefinition());
        }
        if (ctx.directiveDefinition() != null) {
            return this.createDirectiveDefinition(ctx.directiveDefinition());
        }
        if (ctx.typeDefinition() != null) {
            return this.createTypeDefinition(ctx.typeDefinition());
        }
        return (SDLDefinition)Assert.assertShouldNeverHappen();
    }

    protected SDLDefinition createTypeSystemExtension(GraphqlParser.TypeSystemExtensionContext ctx) {
        if (ctx.typeExtension() != null) {
            return this.createTypeExtension(ctx.typeExtension());
        }
        if (ctx.schemaExtension() != null) {
            return this.creationSchemaExtension(ctx.schemaExtension());
        }
        return (SDLDefinition)Assert.assertShouldNeverHappen();
    }

    protected TypeDefinition createTypeExtension(GraphqlParser.TypeExtensionContext ctx) {
        if (ctx.enumTypeExtensionDefinition() != null) {
            return this.createEnumTypeExtensionDefinition(ctx.enumTypeExtensionDefinition());
        }
        if (ctx.objectTypeExtensionDefinition() != null) {
            return this.createObjectTypeExtensionDefinition(ctx.objectTypeExtensionDefinition());
        }
        if (ctx.inputObjectTypeExtensionDefinition() != null) {
            return this.createInputObjectTypeExtensionDefinition(ctx.inputObjectTypeExtensionDefinition());
        }
        if (ctx.interfaceTypeExtensionDefinition() != null) {
            return this.createInterfaceTypeExtensionDefinition(ctx.interfaceTypeExtensionDefinition());
        }
        if (ctx.scalarTypeExtensionDefinition() != null) {
            return this.createScalarTypeExtensionDefinition(ctx.scalarTypeExtensionDefinition());
        }
        if (ctx.unionTypeExtensionDefinition() != null) {
            return this.createUnionTypeExtensionDefinition(ctx.unionTypeExtensionDefinition());
        }
        return (TypeDefinition)Assert.assertShouldNeverHappen();
    }

    protected TypeDefinition createTypeDefinition(GraphqlParser.TypeDefinitionContext ctx) {
        if (ctx.enumTypeDefinition() != null) {
            return this.createEnumTypeDefinition(ctx.enumTypeDefinition());
        }
        if (ctx.objectTypeDefinition() != null) {
            return this.createObjectTypeDefinition(ctx.objectTypeDefinition());
        }
        if (ctx.inputObjectTypeDefinition() != null) {
            return this.createInputObjectTypeDefinition(ctx.inputObjectTypeDefinition());
        }
        if (ctx.interfaceTypeDefinition() != null) {
            return this.createInterfaceTypeDefinition(ctx.interfaceTypeDefinition());
        }
        if (ctx.scalarTypeDefinition() != null) {
            return this.createScalarTypeDefinition(ctx.scalarTypeDefinition());
        }
        if (ctx.unionTypeDefinition() != null) {
            return this.createUnionTypeDefinition(ctx.unionTypeDefinition());
        }
        return (TypeDefinition)Assert.assertShouldNeverHappen();
    }

    protected Type createType(GraphqlParser.TypeContext ctx) {
        if (ctx.typeName() != null) {
            return this.createTypeName(ctx.typeName());
        }
        if (ctx.nonNullType() != null) {
            return this.createNonNullType(ctx.nonNullType());
        }
        if (ctx.listType() != null) {
            return this.createListType(ctx.listType());
        }
        return (Type)Assert.assertShouldNeverHappen();
    }

    protected TypeName createTypeName(GraphqlParser.TypeNameContext ctx) {
        TypeName.Builder builder = TypeName.newTypeName();
        builder.name(ctx.name().getText());
        this.addCommonData(builder, ctx);
        return builder.build();
    }

    protected NonNullType createNonNullType(GraphqlParser.NonNullTypeContext ctx) {
        NonNullType.Builder builder = NonNullType.newNonNullType();
        this.addCommonData(builder, ctx);
        if (ctx.listType() != null) {
            builder.type(this.createListType(ctx.listType()));
        } else if (ctx.typeName() != null) {
            builder.type(this.createTypeName(ctx.typeName()));
        } else {
            return (NonNullType)Assert.assertShouldNeverHappen();
        }
        return builder.build();
    }

    protected ListType createListType(GraphqlParser.ListTypeContext ctx) {
        ListType.Builder builder = ListType.newListType();
        this.addCommonData(builder, ctx);
        builder.type(this.createType(ctx.type()));
        return builder.build();
    }

    protected Argument createArgument(GraphqlParser.ArgumentContext ctx) {
        Argument.Builder builder = Argument.newArgument();
        this.addCommonData(builder, ctx);
        builder.name(ctx.name().getText());
        builder.value(this.createValue(ctx.valueWithVariable()));
        return builder.build();
    }

    protected List<Argument> createArguments(GraphqlParser.ArgumentsContext ctx) {
        if (ctx == null) {
            return new ArrayList<Argument>();
        }
        return ctx.argument().stream().map(this::createArgument).collect(Collectors.toList());
    }

    protected List<Directive> createDirectives(GraphqlParser.DirectivesContext ctx) {
        if (ctx == null) {
            return new ArrayList<Directive>();
        }
        return ctx.directive().stream().map(this::createDirective).collect(Collectors.toList());
    }

    protected Directive createDirective(GraphqlParser.DirectiveContext ctx) {
        Directive.Builder builder = Directive.newDirective();
        builder.name(ctx.name().getText());
        this.addCommonData(builder, ctx);
        builder.arguments(this.createArguments(ctx.arguments()));
        return builder.build();
    }

    protected SchemaDefinition createSchemaDefinition(GraphqlParser.SchemaDefinitionContext ctx) {
        SchemaDefinition.Builder def = SchemaDefinition.newSchemaDefinition();
        this.addCommonData(def, ctx);
        def.directives(this.createDirectives(ctx.directives()));
        def.operationTypeDefinitions(ctx.operationTypeDefinition().stream().map(this::createOperationTypeDefinition).collect(Collectors.toList()));
        return def.build();
    }

    private SDLDefinition creationSchemaExtension(GraphqlParser.SchemaExtensionContext ctx) {
        SchemaExtensionDefinition.Builder def = SchemaExtensionDefinition.newSchemaExtensionDefinition();
        this.addCommonData(def, ctx);
        ArrayList<Directive> directives = new ArrayList<Directive>();
        List<GraphqlParser.DirectivesContext> directivesCtx = ctx.directives();
        for (GraphqlParser.DirectivesContext directiveCtx : directivesCtx) {
            directives.addAll(this.createDirectives(directiveCtx));
        }
        def.directives(directives);
        List<OperationTypeDefinition> operationTypeDefs = ctx.operationTypeDefinition().stream().map(this::createOperationTypeDefinition).collect(Collectors.toList());
        def.operationTypeDefinitions(operationTypeDefs);
        return def.build();
    }

    protected OperationTypeDefinition createOperationTypeDefinition(GraphqlParser.OperationTypeDefinitionContext ctx) {
        OperationTypeDefinition.Builder def = OperationTypeDefinition.newOperationTypeDefinition();
        def.name(ctx.operationType().getText());
        def.typeName(this.createTypeName(ctx.typeName()));
        this.addCommonData(def, ctx);
        return def.build();
    }

    protected ScalarTypeDefinition createScalarTypeDefinition(GraphqlParser.ScalarTypeDefinitionContext ctx) {
        ScalarTypeDefinition.Builder def = ScalarTypeDefinition.newScalarTypeDefinition();
        def.name(ctx.name().getText());
        this.addCommonData(def, ctx);
        def.description(this.newDescription(ctx.description()));
        def.directives(this.createDirectives(ctx.directives()));
        return def.build();
    }

    protected ScalarTypeExtensionDefinition createScalarTypeExtensionDefinition(GraphqlParser.ScalarTypeExtensionDefinitionContext ctx) {
        ScalarTypeExtensionDefinition.Builder def = ScalarTypeExtensionDefinition.newScalarTypeExtensionDefinition();
        def.name(ctx.name().getText());
        this.addCommonData(def, ctx);
        def.directives(this.createDirectives(ctx.directives()));
        return def.build();
    }

    protected ObjectTypeDefinition createObjectTypeDefinition(GraphqlParser.ObjectTypeDefinitionContext ctx) {
        ObjectTypeDefinition.Builder def = ObjectTypeDefinition.newObjectTypeDefinition();
        def.name(ctx.name().getText());
        this.addCommonData(def, ctx);
        def.description(this.newDescription(ctx.description()));
        def.directives(this.createDirectives(ctx.directives()));
        ArrayList<Type> implementz = new ArrayList<Type>();
        for (GraphqlParser.ImplementsInterfacesContext implementsInterfacesContext = ctx.implementsInterfaces(); implementsInterfacesContext != null; implementsInterfacesContext = implementsInterfacesContext.implementsInterfaces()) {
            List typeNames = implementsInterfacesContext.typeName().stream().map(this::createTypeName).collect(Collectors.toList());
            implementz.addAll(0, typeNames);
        }
        def.implementz(implementz);
        if (ctx.fieldsDefinition() != null) {
            def.fieldDefinitions(this.createFieldDefinitions(ctx.fieldsDefinition()));
        }
        return def.build();
    }

    protected ObjectTypeExtensionDefinition createObjectTypeExtensionDefinition(GraphqlParser.ObjectTypeExtensionDefinitionContext ctx) {
        ObjectTypeExtensionDefinition.Builder def = ObjectTypeExtensionDefinition.newObjectTypeExtensionDefinition();
        def.name(ctx.name().getText());
        this.addCommonData(def, ctx);
        def.directives(this.createDirectives(ctx.directives()));
        ArrayList<Type> implementz = new ArrayList<Type>();
        for (GraphqlParser.ImplementsInterfacesContext implementsInterfacesContext = ctx.implementsInterfaces(); implementsInterfacesContext != null; implementsInterfacesContext = implementsInterfacesContext.implementsInterfaces()) {
            List typeNames = implementsInterfacesContext.typeName().stream().map(this::createTypeName).collect(Collectors.toList());
            implementz.addAll(0, typeNames);
        }
        def.implementz(implementz);
        if (ctx.extensionFieldsDefinition() != null) {
            def.fieldDefinitions(this.createFieldDefinitions(ctx.extensionFieldsDefinition()));
        }
        return def.build();
    }

    protected List<FieldDefinition> createFieldDefinitions(GraphqlParser.FieldsDefinitionContext ctx) {
        if (ctx == null) {
            return new ArrayList<FieldDefinition>();
        }
        return ctx.fieldDefinition().stream().map(this::createFieldDefinition).collect(Collectors.toList());
    }

    protected List<FieldDefinition> createFieldDefinitions(GraphqlParser.ExtensionFieldsDefinitionContext ctx) {
        if (ctx == null) {
            return new ArrayList<FieldDefinition>();
        }
        return ctx.fieldDefinition().stream().map(this::createFieldDefinition).collect(Collectors.toList());
    }

    protected FieldDefinition createFieldDefinition(GraphqlParser.FieldDefinitionContext ctx) {
        FieldDefinition.Builder def = FieldDefinition.newFieldDefinition();
        def.name(ctx.name().getText());
        def.type(this.createType(ctx.type()));
        this.addCommonData(def, ctx);
        def.description(this.newDescription(ctx.description()));
        def.directives((List)this.createDirectives(ctx.directives()));
        if (ctx.argumentsDefinition() != null) {
            def.inputValueDefinitions(this.createInputValueDefinitions(ctx.argumentsDefinition().inputValueDefinition()));
        }
        return def.build();
    }

    protected List<InputValueDefinition> createInputValueDefinitions(List<GraphqlParser.InputValueDefinitionContext> defs) {
        return defs.stream().map(this::createInputValueDefinition).collect(Collectors.toList());
    }

    protected InputValueDefinition createInputValueDefinition(GraphqlParser.InputValueDefinitionContext ctx) {
        InputValueDefinition.Builder def = InputValueDefinition.newInputValueDefinition();
        def.name(ctx.name().getText());
        def.type(this.createType(ctx.type()));
        this.addCommonData(def, ctx);
        def.description(this.newDescription(ctx.description()));
        if (ctx.defaultValue() != null) {
            def.defaultValue(this.createValue(ctx.defaultValue().value()));
        }
        def.directives(this.createDirectives(ctx.directives()));
        return def.build();
    }

    protected InterfaceTypeDefinition createInterfaceTypeDefinition(GraphqlParser.InterfaceTypeDefinitionContext ctx) {
        InterfaceTypeDefinition.Builder def = InterfaceTypeDefinition.newInterfaceTypeDefinition();
        def.name(ctx.name().getText());
        this.addCommonData(def, ctx);
        def.description(this.newDescription(ctx.description()));
        def.directives(this.createDirectives(ctx.directives()));
        def.definitions(this.createFieldDefinitions(ctx.fieldsDefinition()));
        return def.build();
    }

    protected InterfaceTypeExtensionDefinition createInterfaceTypeExtensionDefinition(GraphqlParser.InterfaceTypeExtensionDefinitionContext ctx) {
        InterfaceTypeExtensionDefinition.Builder def = InterfaceTypeExtensionDefinition.newInterfaceTypeExtensionDefinition();
        def.name(ctx.name().getText());
        this.addCommonData(def, ctx);
        def.directives(this.createDirectives(ctx.directives()));
        def.definitions(this.createFieldDefinitions(ctx.extensionFieldsDefinition()));
        return def.build();
    }

    protected UnionTypeDefinition createUnionTypeDefinition(GraphqlParser.UnionTypeDefinitionContext ctx) {
        UnionTypeDefinition.Builder def = UnionTypeDefinition.newUnionTypeDefinition();
        def.name(ctx.name().getText());
        this.addCommonData(def, ctx);
        def.description(this.newDescription(ctx.description()));
        def.directives(this.createDirectives(ctx.directives()));
        ArrayList<Type> members = new ArrayList<Type>();
        GraphqlParser.UnionMembershipContext unionMembership = ctx.unionMembership();
        if (unionMembership != null) {
            for (GraphqlParser.UnionMembersContext unionMembersContext = unionMembership.unionMembers(); unionMembersContext != null; unionMembersContext = unionMembersContext.unionMembers()) {
                members.add(0, this.createTypeName(unionMembersContext.typeName()));
            }
        }
        def.memberTypes(members);
        return def.build();
    }

    protected UnionTypeExtensionDefinition createUnionTypeExtensionDefinition(GraphqlParser.UnionTypeExtensionDefinitionContext ctx) {
        UnionTypeExtensionDefinition.Builder def = UnionTypeExtensionDefinition.newUnionTypeExtensionDefinition();
        def.name(ctx.name().getText());
        this.addCommonData(def, ctx);
        def.directives(this.createDirectives(ctx.directives()));
        ArrayList<Type> members = new ArrayList<Type>();
        if (ctx.unionMembership() != null) {
            for (GraphqlParser.UnionMembersContext unionMembersContext = ctx.unionMembership().unionMembers(); unionMembersContext != null; unionMembersContext = unionMembersContext.unionMembers()) {
                members.add(0, this.createTypeName(unionMembersContext.typeName()));
            }
            def.memberTypes(members);
        }
        return def.build();
    }

    protected EnumTypeDefinition createEnumTypeDefinition(GraphqlParser.EnumTypeDefinitionContext ctx) {
        EnumTypeDefinition.Builder def = EnumTypeDefinition.newEnumTypeDefinition();
        def.name(ctx.name().getText());
        this.addCommonData(def, ctx);
        def.description(this.newDescription(ctx.description()));
        def.directives(this.createDirectives(ctx.directives()));
        if (ctx.enumValueDefinitions() != null) {
            def.enumValueDefinitions(ctx.enumValueDefinitions().enumValueDefinition().stream().map(this::createEnumValueDefinition).collect(Collectors.toList()));
        }
        return def.build();
    }

    protected EnumTypeExtensionDefinition createEnumTypeExtensionDefinition(GraphqlParser.EnumTypeExtensionDefinitionContext ctx) {
        EnumTypeExtensionDefinition.Builder def = EnumTypeExtensionDefinition.newEnumTypeExtensionDefinition();
        def.name(ctx.name().getText());
        this.addCommonData(def, ctx);
        def.directives(this.createDirectives(ctx.directives()));
        if (ctx.extensionEnumValueDefinitions() != null) {
            def.enumValueDefinitions(ctx.extensionEnumValueDefinitions().enumValueDefinition().stream().map(this::createEnumValueDefinition).collect(Collectors.toList()));
        }
        return def.build();
    }

    protected EnumValueDefinition createEnumValueDefinition(GraphqlParser.EnumValueDefinitionContext ctx) {
        EnumValueDefinition.Builder def = EnumValueDefinition.newEnumValueDefinition();
        def.name(ctx.enumValue().getText());
        this.addCommonData(def, ctx);
        def.description(this.newDescription(ctx.description()));
        def.directives((List)this.createDirectives(ctx.directives()));
        return def.build();
    }

    protected InputObjectTypeDefinition createInputObjectTypeDefinition(GraphqlParser.InputObjectTypeDefinitionContext ctx) {
        InputObjectTypeDefinition.Builder def = InputObjectTypeDefinition.newInputObjectDefinition();
        def.name(ctx.name().getText());
        this.addCommonData(def, ctx);
        def.description(this.newDescription(ctx.description()));
        def.directives(this.createDirectives(ctx.directives()));
        if (ctx.inputObjectValueDefinitions() != null) {
            def.inputValueDefinitions(this.createInputValueDefinitions(ctx.inputObjectValueDefinitions().inputValueDefinition()));
        }
        return def.build();
    }

    protected InputObjectTypeExtensionDefinition createInputObjectTypeExtensionDefinition(GraphqlParser.InputObjectTypeExtensionDefinitionContext ctx) {
        InputObjectTypeExtensionDefinition.Builder def = InputObjectTypeExtensionDefinition.newInputObjectTypeExtensionDefinition();
        def.name(ctx.name().getText());
        this.addCommonData(def, ctx);
        def.directives(this.createDirectives(ctx.directives()));
        if (ctx.extensionInputObjectValueDefinitions() != null) {
            def.inputValueDefinitions(this.createInputValueDefinitions(ctx.extensionInputObjectValueDefinitions().inputValueDefinition()));
        }
        return def.build();
    }

    protected DirectiveDefinition createDirectiveDefinition(GraphqlParser.DirectiveDefinitionContext ctx) {
        DirectiveDefinition.Builder def = DirectiveDefinition.newDirectiveDefinition();
        def.name(ctx.name().getText());
        this.addCommonData(def, ctx);
        def.description(this.newDescription(ctx.description()));
        ArrayList<DirectiveLocation> directiveLocations = new ArrayList<DirectiveLocation>();
        for (GraphqlParser.DirectiveLocationsContext directiveLocationsContext = ctx.directiveLocations(); directiveLocationsContext != null; directiveLocationsContext = directiveLocationsContext.directiveLocations()) {
            directiveLocations.add(0, this.createDirectiveLocation(directiveLocationsContext.directiveLocation()));
        }
        def.directiveLocations(directiveLocations);
        if (ctx.argumentsDefinition() != null) {
            def.inputValueDefinitions(this.createInputValueDefinitions(ctx.argumentsDefinition().inputValueDefinition()));
        }
        return def.build();
    }

    protected DirectiveLocation createDirectiveLocation(GraphqlParser.DirectiveLocationContext ctx) {
        DirectiveLocation.Builder def = DirectiveLocation.newDirectiveLocation();
        def.name(ctx.name().getText());
        this.addCommonData(def, ctx);
        return def.build();
    }

    protected Value createValue(GraphqlParser.ValueWithVariableContext ctx) {
        if (ctx.IntValue() != null) {
            IntValue.Builder intValue = IntValue.newIntValue().value(new BigInteger(ctx.IntValue().getText()));
            this.addCommonData(intValue, ctx);
            return intValue.build();
        }
        if (ctx.FloatValue() != null) {
            FloatValue.Builder floatValue = FloatValue.newFloatValue().value(new BigDecimal(ctx.FloatValue().getText()));
            this.addCommonData(floatValue, ctx);
            return floatValue.build();
        }
        if (ctx.BooleanValue() != null) {
            BooleanValue.Builder booleanValue = BooleanValue.newBooleanValue().value(Boolean.parseBoolean(ctx.BooleanValue().getText()));
            this.addCommonData(booleanValue, ctx);
            return booleanValue.build();
        }
        if (ctx.NullValue() != null) {
            return NullValue.Null;
        }
        if (ctx.stringValue() != null) {
            StringValue.Builder stringValue = StringValue.newStringValue().value(GraphqlAntlrToLanguage.quotedString(ctx.stringValue()));
            this.addCommonData(stringValue, ctx);
            return stringValue.build();
        }
        if (ctx.enumValue() != null) {
            EnumValue.Builder enumValue = EnumValue.newEnumValue().name(ctx.enumValue().getText());
            this.addCommonData(enumValue, ctx);
            return enumValue.build();
        }
        if (ctx.arrayValueWithVariable() != null) {
            ArrayValue.Builder arrayValue = ArrayValue.newArrayValue();
            this.addCommonData(arrayValue, ctx);
            ArrayList<Value> values = new ArrayList<Value>();
            for (GraphqlParser.ValueWithVariableContext valueWithVariableContext : ctx.arrayValueWithVariable().valueWithVariable()) {
                values.add(this.createValue(valueWithVariableContext));
            }
            return arrayValue.values(values).build();
        }
        if (ctx.objectValueWithVariable() != null) {
            ObjectValue.Builder objectValue = ObjectValue.newObjectValue();
            this.addCommonData(objectValue, ctx);
            ArrayList<ObjectField> objectFields = new ArrayList<ObjectField>();
            for (GraphqlParser.ObjectFieldWithVariableContext objectFieldWithVariableContext : ctx.objectValueWithVariable().objectFieldWithVariable()) {
                ObjectField objectField = ObjectField.newObjectField().name(objectFieldWithVariableContext.name().getText()).value(this.createValue(objectFieldWithVariableContext.valueWithVariable())).build();
                objectFields.add(objectField);
            }
            return objectValue.objectFields(objectFields).build();
        }
        if (ctx.variable() != null) {
            VariableReference.Builder variableReference = VariableReference.newVariableReference().name(ctx.variable().name().getText());
            this.addCommonData(variableReference, ctx);
            return variableReference.build();
        }
        return (Value)Assert.assertShouldNeverHappen();
    }

    protected Value createValue(GraphqlParser.ValueContext ctx) {
        if (ctx.IntValue() != null) {
            IntValue.Builder intValue = IntValue.newIntValue().value(new BigInteger(ctx.IntValue().getText()));
            this.addCommonData(intValue, ctx);
            return intValue.build();
        }
        if (ctx.FloatValue() != null) {
            FloatValue.Builder floatValue = FloatValue.newFloatValue().value(new BigDecimal(ctx.FloatValue().getText()));
            this.addCommonData(floatValue, ctx);
            return floatValue.build();
        }
        if (ctx.BooleanValue() != null) {
            BooleanValue.Builder booleanValue = BooleanValue.newBooleanValue().value(Boolean.parseBoolean(ctx.BooleanValue().getText()));
            this.addCommonData(booleanValue, ctx);
            return booleanValue.build();
        }
        if (ctx.NullValue() != null) {
            return NullValue.Null;
        }
        if (ctx.stringValue() != null) {
            StringValue.Builder stringValue = StringValue.newStringValue().value(GraphqlAntlrToLanguage.quotedString(ctx.stringValue()));
            this.addCommonData(stringValue, ctx);
            return stringValue.build();
        }
        if (ctx.enumValue() != null) {
            EnumValue.Builder enumValue = EnumValue.newEnumValue().name(ctx.enumValue().getText());
            this.addCommonData(enumValue, ctx);
            return enumValue.build();
        }
        if (ctx.arrayValue() != null) {
            ArrayValue.Builder arrayValue = ArrayValue.newArrayValue();
            this.addCommonData(arrayValue, ctx);
            ArrayList<Value> values = new ArrayList<Value>();
            for (GraphqlParser.ValueContext valueContext : ctx.arrayValue().value()) {
                values.add(this.createValue(valueContext));
            }
            return arrayValue.values(values).build();
        }
        if (ctx.objectValue() != null) {
            ObjectValue.Builder objectValue = ObjectValue.newObjectValue();
            this.addCommonData(objectValue, ctx);
            ArrayList<ObjectField> objectFields = new ArrayList<ObjectField>();
            for (GraphqlParser.ObjectFieldContext objectFieldContext : ctx.objectValue().objectField()) {
                ObjectField objectField = ObjectField.newObjectField().name(objectFieldContext.name().getText()).value(this.createValue(objectFieldContext.value())).build();
                objectFields.add(objectField);
            }
            return objectValue.objectFields(objectFields).build();
        }
        return (Value)Assert.assertShouldNeverHappen();
    }

    static String quotedString(GraphqlParser.StringValueContext ctx) {
        boolean multiLine = ctx.TripleQuotedStringValue() != null;
        String strText = ctx.getText();
        if (multiLine) {
            return StringValueParsing.parseTripleQuotedString(strText);
        }
        return StringValueParsing.parseSingleQuotedString(strText);
    }

    protected void addCommonData(NodeBuilder nodeBuilder, ParserRuleContext parserRuleContext) {
        List<Comment> comments = this.getComments(parserRuleContext);
        if (!comments.isEmpty()) {
            nodeBuilder.comments(comments);
        }
        nodeBuilder.sourceLocation(this.getSourceLocation(parserRuleContext));
        this.addIgnoredChars(parserRuleContext, nodeBuilder);
    }

    private void addIgnoredChars(ParserRuleContext ctx, NodeBuilder nodeBuilder) {
        Token start = ctx.getStart();
        int tokenStartIndex = start.getTokenIndex();
        List leftChannel = this.tokens.getHiddenTokensToLeft(tokenStartIndex, 3);
        List<IgnoredChar> ignoredCharsLeft = this.mapTokenToIgnoredChar(leftChannel);
        Token stop = ctx.getStop();
        int tokenStopIndex = stop.getTokenIndex();
        List rightChannel = this.tokens.getHiddenTokensToRight(tokenStopIndex, 3);
        List<IgnoredChar> ignoredCharsRight = this.mapTokenToIgnoredChar(rightChannel);
        nodeBuilder.ignoredChars(new IgnoredChars(ignoredCharsLeft, ignoredCharsRight));
    }

    private List<IgnoredChar> mapTokenToIgnoredChar(List<Token> tokens) {
        if (tokens == null) {
            return Collections.emptyList();
        }
        return tokens.stream().map(this::createIgnoredChar).collect(Collectors.toList());
    }

    private IgnoredChar createIgnoredChar(Token token) {
        IgnoredChar.IgnoredCharKind kind;
        String symbolicName;
        switch (symbolicName = GraphqlLexer.VOCABULARY.getSymbolicName(token.getType())) {
            case "CR": {
                kind = IgnoredChar.IgnoredCharKind.CR;
                break;
            }
            case "LF": {
                kind = IgnoredChar.IgnoredCharKind.LF;
                break;
            }
            case "Tab": {
                kind = IgnoredChar.IgnoredCharKind.TAB;
                break;
            }
            case "Comma": {
                kind = IgnoredChar.IgnoredCharKind.COMMA;
                break;
            }
            case "Space": {
                kind = IgnoredChar.IgnoredCharKind.SPACE;
                break;
            }
            default: {
                kind = IgnoredChar.IgnoredCharKind.OTHER;
            }
        }
        return new IgnoredChar(token.getText(), kind, this.getSourceLocation(token));
    }

    protected Description newDescription(GraphqlParser.DescriptionContext descriptionCtx) {
        if (descriptionCtx == null) {
            return null;
        }
        GraphqlParser.StringValueContext stringValueCtx = descriptionCtx.stringValue();
        if (stringValueCtx == null) {
            return null;
        }
        boolean multiLine = stringValueCtx.TripleQuotedStringValue() != null;
        String content = stringValueCtx.getText();
        content = multiLine ? StringValueParsing.parseTripleQuotedString(content) : StringValueParsing.parseSingleQuotedString(content);
        SourceLocation sourceLocation = this.getSourceLocation(descriptionCtx);
        return new Description(content, sourceLocation, multiLine);
    }

    protected SourceLocation getSourceLocation(Token token) {
        return AntlrHelper.createSourceLocation(this.multiSourceReader, token);
    }

    protected SourceLocation getSourceLocation(ParserRuleContext parserRuleContext) {
        return this.getSourceLocation(parserRuleContext.getStart());
    }

    protected List<Comment> getComments(ParserRuleContext ctx) {
        int tokPos;
        List refChannel;
        Token start = ctx.getStart();
        if (start != null && (refChannel = this.tokens.getHiddenTokensToLeft(tokPos = start.getTokenIndex(), 2)) != null) {
            return this.getCommentOnChannel(refChannel);
        }
        return Collections.emptyList();
    }

    protected List<Comment> getCommentOnChannel(List<Token> refChannel) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        for (Token refTok : refChannel) {
            String text = refTok.getText();
            if (text == null) continue;
            text = text.replaceFirst("^#", "");
            MultiSourceReader.SourceAndLine sourceAndLine = this.multiSourceReader.getSourceAndLineFromOverallLine(refTok.getLine());
            int column = refTok.getCharPositionInLine();
            int line = sourceAndLine.getLine() + 1;
            comments.add(new Comment(text, new SourceLocation(line, column, sourceAndLine.getSourceName())));
        }
        return comments;
    }
}

