/*
 * Decompiled with CFR 0.152.
 */
package graphql.parser;

import graphql.Internal;
import graphql.language.Document;
import graphql.language.SourceLocation;
import graphql.parser.AntlrHelper;
import graphql.parser.ExtendedBailStrategy;
import graphql.parser.GraphqlAntlrToLanguage;
import graphql.parser.InvalidSyntaxException;
import graphql.parser.MultiSourceReader;
import graphql.parser.antlr.GraphqlLexer;
import graphql.parser.antlr.GraphqlParser;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;

@Internal
public class Parser {
    public static Document parse(String input) {
        return new Parser().parseDocument(input);
    }

    public Document parseDocument(String input) throws InvalidSyntaxException {
        return this.parseDocument(input, null);
    }

    public Document parseDocument(String input, String sourceName) throws InvalidSyntaxException {
        MultiSourceReader multiSourceReader = MultiSourceReader.newMultiSourceReader().string(input, sourceName).trackData(true).build();
        return this.parseDocument(multiSourceReader);
    }

    public Document parseDocument(Reader reader) throws InvalidSyntaxException {
        CodePointCharStream charStream;
        final MultiSourceReader multiSourceReader = reader instanceof MultiSourceReader ? (MultiSourceReader)reader : MultiSourceReader.newMultiSourceReader().reader(reader, null).build();
        try {
            charStream = CharStreams.fromReader((Reader)multiSourceReader);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        GraphqlLexer lexer = new GraphqlLexer((CharStream)charStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                SourceLocation sourceLocation = AntlrHelper.createSourceLocation(multiSourceReader, line, charPositionInLine);
                String preview = AntlrHelper.createPreview(multiSourceReader, line);
                throw new InvalidSyntaxException(sourceLocation, "Invalid syntax: " + msg, preview, null, null);
            }
        });
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        GraphqlParser parser = new GraphqlParser((TokenStream)tokens);
        parser.removeErrorListeners();
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        ExtendedBailStrategy bailStrategy = new ExtendedBailStrategy(multiSourceReader);
        parser.setErrorHandler((ANTLRErrorStrategy)bailStrategy);
        GraphqlAntlrToLanguage toLanguage = new GraphqlAntlrToLanguage(tokens, multiSourceReader);
        GraphqlParser.DocumentContext documentContext = parser.document();
        Document doc = toLanguage.createDocument(documentContext);
        Token stop = documentContext.getStop();
        List allTokens = tokens.getTokens();
        if (stop != null && allTokens != null && !allTokens.isEmpty()) {
            boolean sameChannel;
            Token last = (Token)allTokens.get(allTokens.size() - 1);
            boolean notEOF = last.getType() != -1;
            boolean lastGreaterThanDocument = last.getTokenIndex() > stop.getTokenIndex();
            boolean bl = sameChannel = last.getChannel() == stop.getChannel();
            if (notEOF && lastGreaterThanDocument && sameChannel) {
                throw bailStrategy.mkMoreTokensException(last);
            }
        }
        return doc;
    }
}

