/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.asyncapi.io;

import io.apicurio.datamodels.asyncapi.models.AaiChannelBindings;
import io.apicurio.datamodels.asyncapi.models.AaiChannelBindingsDefinition;
import io.apicurio.datamodels.asyncapi.models.AaiChannelItem;
import io.apicurio.datamodels.asyncapi.models.AaiComponents;
import io.apicurio.datamodels.asyncapi.models.AaiCorrelationId;
import io.apicurio.datamodels.asyncapi.models.AaiDocument;
import io.apicurio.datamodels.asyncapi.models.AaiExternalDocumentation;
import io.apicurio.datamodels.asyncapi.models.AaiHeaderItem;
import io.apicurio.datamodels.asyncapi.models.AaiMessage;
import io.apicurio.datamodels.asyncapi.models.AaiMessageBase;
import io.apicurio.datamodels.asyncapi.models.AaiMessageBindings;
import io.apicurio.datamodels.asyncapi.models.AaiMessageBindingsDefinition;
import io.apicurio.datamodels.asyncapi.models.AaiMessageTrait;
import io.apicurio.datamodels.asyncapi.models.AaiMessageTraitDefinition;
import io.apicurio.datamodels.asyncapi.models.AaiOAuthFlows;
import io.apicurio.datamodels.asyncapi.models.AaiOperation;
import io.apicurio.datamodels.asyncapi.models.AaiOperationBase;
import io.apicurio.datamodels.asyncapi.models.AaiOperationBindings;
import io.apicurio.datamodels.asyncapi.models.AaiOperationBindingsDefinition;
import io.apicurio.datamodels.asyncapi.models.AaiOperationTrait;
import io.apicurio.datamodels.asyncapi.models.AaiOperationTraitDefinition;
import io.apicurio.datamodels.asyncapi.models.AaiParameter;
import io.apicurio.datamodels.asyncapi.models.AaiSecurityRequirement;
import io.apicurio.datamodels.asyncapi.models.AaiSecurityScheme;
import io.apicurio.datamodels.asyncapi.models.AaiServer;
import io.apicurio.datamodels.asyncapi.models.AaiServerBindings;
import io.apicurio.datamodels.asyncapi.models.AaiServerBindingsDefinition;
import io.apicurio.datamodels.asyncapi.models.AaiServerVariable;
import io.apicurio.datamodels.asyncapi.models.AaiTag;
import io.apicurio.datamodels.asyncapi.models.IAaiNodeFactory;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.core.io.DataModelReader;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.common.Components;
import io.apicurio.datamodels.core.models.common.OAuthFlows;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.models.common.SecurityScheme;
import io.apicurio.datamodels.core.models.common.Server;
import io.apicurio.datamodels.core.models.common.ServerVariable;
import java.util.List;

public abstract class AaiDataModelReader
extends DataModelReader {
    private final IAaiNodeFactory nodeFactory;

    public AaiDataModelReader(IAaiNodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    @Override
    public void readDocument(Object json, Document node) {
        Object json_;
        Object serversJson;
        AaiDocument doc = (AaiDocument)node;
        doc.asyncapi = JsonCompat.consumePropertyString(json, "asyncapi");
        doc.id = JsonCompat.consumePropertyString(json, "id");
        doc.defaultContentType = JsonCompat.consumePropertyString(json, "defaultContentType");
        Object channels = JsonCompat.consumeProperty(json, "channels");
        if (channels != null) {
            JsonCompat.keys(channels).forEach(key -> {
                Object json_ = JsonCompat.consumeProperty(channels, key);
                AaiChannelItem value = this.nodeFactory.createChannelItem(node, (String)key);
                this.readChannelItem(json_, value);
                doc.addChannelItem(value);
            });
        }
        if ((serversJson = JsonCompat.consumeProperty(json, "servers")) != null) {
            JsonCompat.keys(serversJson).forEach(key -> {
                Object serverJson = JsonCompat.consumeProperty(serversJson, key);
                AaiServer serverModel = this.nodeFactory.createServer(node, (String)key);
                this.readServer(serverJson, serverModel);
                doc.addServer((String)key, serverModel);
            });
        }
        if ((json_ = JsonCompat.consumeProperty(json, "components")) != null) {
            AaiComponents components = this.nodeFactory.createComponents(node);
            this.readComponents(json_, components);
            doc.components = components;
        }
        super.readDocument(json, doc);
    }

    public void readChannelItem(Object json, AaiChannelItem node) {
        Object jsonP_;
        AaiOperation operation;
        node.$ref = JsonCompat.consumePropertyString(json, "$ref");
        node.description = JsonCompat.consumePropertyString(json, "description");
        Object json_ = JsonCompat.consumeProperty(json, "subscribe");
        if (json_ != null) {
            operation = this.nodeFactory.createOperation(node, "subscribe");
            this.readOperation(json_, operation);
            node.subscribe = operation;
        }
        if ((json_ = JsonCompat.consumeProperty(json, "publish")) != null) {
            operation = this.nodeFactory.createOperation(node, "publish");
            this.readOperation(json_, operation);
            node.publish = operation;
        }
        if ((jsonP_ = JsonCompat.consumeProperty(json, "parameters")) != null && JsonCompat.isObject(jsonP_)) {
            JsonCompat.keys(jsonP_).forEach(key -> {
                Object param = JsonCompat.consumeProperty(jsonP_, key);
                AaiParameter paramModel = this.nodeFactory.createParameter(node, (String)key);
                this.readAaiParameter(param, paramModel);
                node.addParameter((String)key, paramModel);
            });
        }
        if ((json_ = JsonCompat.consumeProperty(json, "bindings")) != null) {
            AaiChannelBindings channelBindingsModel = this.nodeFactory.createChannelBindings(node);
            this.readChannelBindings(json_, channelBindingsModel);
            node.bindings = channelBindingsModel;
        }
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    @Override
    public void readServer(Object json, Server node) {
        Object bindings;
        AaiServer aaiNode = (AaiServer)node;
        aaiNode.protocol = JsonCompat.consumePropertyString(json, "protocol");
        aaiNode.protocolVersion = JsonCompat.consumePropertyString(json, "protocolVersion");
        List<Object> security = JsonCompat.consumePropertyArray(json, "security");
        if (security != null) {
            security.forEach(sec -> {
                AaiSecurityRequirement secModel = this.nodeFactory.createSecurityRequirement(node);
                this.readSecurityRequirement(sec, secModel);
                aaiNode.addSecurityRequirement(secModel);
            });
        }
        if ((bindings = JsonCompat.consumeProperty(json, "bindings")) != null) {
            AaiServerBindings serverBindingsModel = this.nodeFactory.createServerBindings(node);
            this.readServerBindings(bindings, serverBindingsModel);
            aaiNode.bindings = serverBindingsModel;
        }
        super.readServer(json, node);
    }

    @Override
    public void readServerVariable(Object json, ServerVariable node) {
        AaiServerVariable aaiNode = (AaiServerVariable)node;
        List<String> examples = JsonCompat.consumePropertyStringArray(json, "examples");
        aaiNode.examples = examples;
        super.readServerVariable(json, node);
    }

    @Override
    public void readOperation(Object json, Operation node) {
        Object json_;
        AaiOperation aaiNode = (AaiOperation)node;
        List<Object> traits = JsonCompat.consumePropertyArray(json, "traits");
        if (traits != null) {
            traits.forEach(trait -> {
                AaiOperationTrait traitModel = this.nodeFactory.createOperationTrait(node, null);
                this.readOperationTrait(trait, traitModel);
                aaiNode.addTrait(traitModel);
            });
        }
        if ((json_ = JsonCompat.consumeProperty(json, "message")) != null) {
            AaiMessage value = this.nodeFactory.createMessage(node, null);
            this.readMessage(json_, value);
            aaiNode.message = value;
        }
        this.readOperationBase(json, aaiNode);
    }

    public void readMessage(Object json, AaiMessage node) {
        List<Object> oneOfJson;
        List<Object> traits;
        Object jPayload = JsonCompat.consumeProperty(json, "payload");
        if (jPayload != null) {
            node.payload = jPayload;
        }
        if ((traits = JsonCompat.consumePropertyArray(json, "traits")) != null) {
            traits.forEach(trait -> {
                AaiMessageTrait traitModel = this.nodeFactory.createMessageTrait(node, null);
                this.readMessageTrait(trait, traitModel);
                node.addTrait(traitModel);
            });
        }
        if ((oneOfJson = JsonCompat.consumePropertyArray(json, "oneOf")) != null) {
            for (Object itemJson : oneOfJson) {
                AaiMessage item = this.nodeFactory.createMessage(node, null);
                this.readMessage(itemJson, item);
                item._isOneOfMessage = true;
                node.addOneOfMessage(item);
            }
        }
        this.readMessageBase(json, node);
    }

    public void readMessageBase(Object json, AaiMessageBase node) {
        Object bindings;
        Object jsonED;
        Object jsonCI;
        Object jsonHeaders = JsonCompat.consumeProperty(json, "headers");
        if (jsonHeaders != null) {
            AaiHeaderItem headerModel = this.nodeFactory.createHeaderItem(node);
            this.readHeaderItem(jsonHeaders, headerModel);
            node.headers = headerModel;
        }
        if ((jsonCI = JsonCompat.consumeProperty(json, "correlationId")) != null) {
            AaiCorrelationId value = this.nodeFactory.createCorrelationId(node, null);
            this.readCorrelationId(jsonCI, value);
            node.correlationId = value;
        }
        node.schemaFormat = JsonCompat.consumePropertyString(json, "schemaFormat");
        node.contentType = JsonCompat.consumePropertyString(json, "contentType");
        node.name = JsonCompat.consumePropertyString(json, "name");
        node.title = JsonCompat.consumePropertyString(json, "title");
        node.summary = JsonCompat.consumePropertyString(json, "summary");
        node.description = JsonCompat.consumePropertyString(json, "description");
        node.$ref = JsonCompat.consumePropertyString(json, "$ref");
        List<Object> jsonTags = JsonCompat.consumePropertyArray(json, "tags");
        if (jsonTags != null) {
            jsonTags.forEach(j -> {
                AaiTag tag = this.nodeFactory.createTag(node);
                this.readTag(j, tag);
                node.addTag(tag);
            });
        }
        if ((jsonED = JsonCompat.consumeProperty(json, "externalDocs")) != null) {
            AaiExternalDocumentation value = this.nodeFactory.createExternalDocumentation(node);
            this.readExternalDocumentation(jsonED, value);
            node.externalDocs = value;
        }
        if ((bindings = JsonCompat.consumeProperty(json, "bindings")) != null) {
            AaiMessageBindings bindingsModel = this.nodeFactory.createMessageBindings(node);
            this.readMessageBindings(bindings, bindingsModel);
            node.bindings = bindingsModel;
        }
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    public void readCorrelationId(Object json, AaiCorrelationId node) {
        node.$ref = JsonCompat.consumePropertyString(json, "$ref");
        node.location = JsonCompat.consumePropertyString(json, "location");
        node.description = JsonCompat.consumePropertyString(json, "description");
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    public void readHeaderItem(Object json, AaiHeaderItem node) {
        String ref = JsonCompat.consumePropertyString(json, "$ref");
        if (ref != null) {
            node.$ref = ref;
        } else {
            node._schemaRaw = json;
        }
    }

    public void readMessageTrait(Object json, AaiMessageTrait node) {
        this.readMessageBase(json, node);
    }

    public void readOperationBase(Object json, AaiOperationBase node) {
        Object bindings;
        node.$ref = JsonCompat.consumePropertyString(json, "$ref");
        List<Object> jsonTags = JsonCompat.consumePropertyArray(json, "tags");
        if (jsonTags != null) {
            jsonTags.forEach(j -> {
                AaiTag tag = this.nodeFactory.createTag(node);
                this.readTag(j, tag);
                node.addTag(tag);
            });
        }
        if ((bindings = JsonCompat.consumeProperty(json, "bindings")) != null) {
            AaiOperationBindings operationBindingsModel = this.nodeFactory.createOperationBindings(node);
            this.readOperationBindings(bindings, operationBindingsModel);
            node.bindings = operationBindingsModel;
        }
        super.readOperation(json, node);
    }

    public void readOperationTrait(Object json, AaiOperationTrait node) {
        this.readOperationBase(json, node);
    }

    public void readComponents(Object json, Components node) {
        Object _jsonMessageBindings;
        Object _jsonOpBindings;
        Object _jsonChannelBindings;
        Object _jsonServerBindings;
        Object _jsonMessageTraits;
        Object _jsonOpTraits;
        Object _jsonCorrelationIds;
        Object _jsonParams;
        Object _jsonSecuritySchemes;
        Object _jsonMessages;
        AaiComponents components = (AaiComponents)node;
        Object _jsonSchemas = JsonCompat.consumeProperty(json, "schemas");
        if (_jsonSchemas != null) {
            JsonCompat.keys(_jsonSchemas).forEach(key -> {
                Object value = JsonCompat.consumeProperty(_jsonSchemas, key);
                components.addSchema((String)key, value);
            });
        }
        if ((_jsonMessages = JsonCompat.consumeProperty(json, "messages")) != null) {
            JsonCompat.keys(_jsonMessages).forEach(key -> {
                Object jsonValue = JsonCompat.consumeProperty(_jsonMessages, key);
                AaiMessage value = this.nodeFactory.createMessage(node, (String)key);
                this.readMessage(jsonValue, value);
                components.addMessage((String)key, value);
            });
        }
        if ((_jsonSecuritySchemes = JsonCompat.consumeProperty(json, "securitySchemes")) != null) {
            JsonCompat.keys(_jsonSecuritySchemes).forEach(key -> {
                Object jsonValue = JsonCompat.consumeProperty(_jsonSecuritySchemes, key);
                AaiSecurityScheme value = this.nodeFactory.createSecurityScheme(node, (String)key);
                this.readSecurityScheme(jsonValue, value);
                components.addSecurityScheme((String)key, value);
            });
        }
        if ((_jsonParams = JsonCompat.consumeProperty(json, "parameters")) != null) {
            JsonCompat.keys(_jsonParams).forEach(key -> {
                Object jsonValue = JsonCompat.consumeProperty(_jsonParams, key);
                AaiParameter value = this.nodeFactory.createParameter(node, (String)key);
                this.readAaiParameter(jsonValue, value);
                components.addParameter((String)key, value);
            });
        }
        if ((_jsonCorrelationIds = JsonCompat.consumeProperty(json, "correlationIds")) != null) {
            JsonCompat.keys(_jsonCorrelationIds).forEach(key -> {
                Object jsonValue = JsonCompat.consumeProperty(_jsonCorrelationIds, key);
                AaiCorrelationId value = this.nodeFactory.createCorrelationId(node, (String)key);
                this.readCorrelationId(jsonValue, value);
                components.addCorrelationId((String)key, value);
            });
        }
        if ((_jsonOpTraits = JsonCompat.consumeProperty(json, "operationTraits")) != null) {
            JsonCompat.keys(_jsonOpTraits).forEach(key -> {
                Object jsonValue = JsonCompat.consumeProperty(_jsonOpTraits, key);
                AaiOperationTraitDefinition traitDef = this.nodeFactory.createOperationTraitDefinition(node, (String)key);
                this.readOperationTrait(jsonValue, traitDef);
                components.addOperationTraitDefinition((String)key, traitDef);
            });
        }
        if ((_jsonMessageTraits = JsonCompat.consumeProperty(json, "messageTraits")) != null) {
            JsonCompat.keys(_jsonMessageTraits).forEach(key -> {
                Object jsonValue = JsonCompat.consumeProperty(_jsonMessageTraits, key);
                AaiMessageTraitDefinition traitDef = this.nodeFactory.createMessageTraitDefinition(node, (String)key);
                this.readMessageTrait(jsonValue, traitDef);
                components.addMessageTraitDefinition((String)key, traitDef);
            });
        }
        if ((_jsonServerBindings = JsonCompat.consumeProperty(json, "serverBindings")) != null) {
            JsonCompat.keys(_jsonServerBindings).forEach(key -> {
                Object jsonValue = JsonCompat.consumeProperty(_jsonServerBindings, key);
                AaiServerBindingsDefinition bindingsDef = this.nodeFactory.createServerBindingsDefinition(node, (String)key);
                this.readServerBindings(jsonValue, bindingsDef);
                components.addServerBindingDefinition((String)key, bindingsDef);
            });
        }
        if ((_jsonChannelBindings = JsonCompat.consumeProperty(json, "channelBindings")) != null) {
            JsonCompat.keys(_jsonChannelBindings).forEach(key -> {
                Object jsonValue = JsonCompat.consumeProperty(_jsonChannelBindings, key);
                AaiChannelBindingsDefinition bindingsDef = this.nodeFactory.createChannelBindingsDefinition(node, (String)key);
                this.readChannelBindings(jsonValue, bindingsDef);
                components.addChannelBindingDefinition((String)key, bindingsDef);
            });
        }
        if ((_jsonOpBindings = JsonCompat.consumeProperty(json, "operationBindings")) != null) {
            JsonCompat.keys(_jsonOpBindings).forEach(key -> {
                Object jsonValue = JsonCompat.consumeProperty(_jsonOpBindings, key);
                AaiOperationBindingsDefinition bindingsDef = this.nodeFactory.createOperationBindingsDefinition(node, (String)key);
                this.readOperationBindings(jsonValue, bindingsDef);
                components.addOperationBindingDefinition((String)key, bindingsDef);
            });
        }
        if ((_jsonMessageBindings = JsonCompat.consumeProperty(json, "messageBindings")) != null) {
            JsonCompat.keys(_jsonMessageBindings).forEach(key -> {
                Object jsonValue = JsonCompat.consumeProperty(_jsonMessageBindings, key);
                AaiMessageBindingsDefinition bindingsDef = this.nodeFactory.createMessageBindingsDefinition(node, (String)key);
                this.readMessageBindings(jsonValue, bindingsDef);
                components.addMessageBindingDefinition((String)key, bindingsDef);
            });
        }
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    @Override
    public void readSecurityScheme(Object json, SecurityScheme node) {
        AaiSecurityScheme aaiNode = (AaiSecurityScheme)node;
        aaiNode.$ref = JsonCompat.consumePropertyString(json, "$ref");
        aaiNode.scheme = JsonCompat.consumePropertyString(json, "scheme");
        Object jsonFlows = JsonCompat.consumeProperty(json, "flows");
        if (jsonFlows != null) {
            AaiOAuthFlows value = this.nodeFactory.createOAuthFlows(node);
            this.readOAuthFlows(jsonFlows, value);
            aaiNode.flows = value;
        }
        aaiNode.openIdConnectUrl = JsonCompat.consumePropertyString(json, "openIdConnectUrl");
        aaiNode.bearerFormat = JsonCompat.consumePropertyString(json, "bearerFormat");
        super.readSecurityScheme(json, aaiNode);
    }

    @Override
    public void readOAuthFlows(Object json, OAuthFlows node) {
        super.readOAuthFlows(json, node);
    }

    public void readChannelBindings(Object json, AaiChannelBindings node) {
        node.http = JsonCompat.consumeProperty(json, "http");
        node.ws = JsonCompat.consumeProperty(json, "ws");
        node.kafka = JsonCompat.consumeProperty(json, "kafka");
        node.amqp = JsonCompat.consumeProperty(json, "amqp");
        node.amqp1 = JsonCompat.consumeProperty(json, "amqp1");
        node.mqtt = JsonCompat.consumeProperty(json, "mqtt");
        node.mqtt5 = JsonCompat.consumeProperty(json, "mqtt5");
        node.nats = JsonCompat.consumeProperty(json, "nats");
        node.jms = JsonCompat.consumeProperty(json, "jms");
        node.sns = JsonCompat.consumeProperty(json, "sns");
        node.sqs = JsonCompat.consumeProperty(json, "sqs");
        node.stomp = JsonCompat.consumeProperty(json, "stomp");
        node.redis = JsonCompat.consumeProperty(json, "redis");
        this.readExtraProperties(json, node);
    }

    public void readMessageBindings(Object json, AaiMessageBindings node) {
        node.http = JsonCompat.consumeProperty(json, "http");
        node.ws = JsonCompat.consumeProperty(json, "ws");
        node.kafka = JsonCompat.consumeProperty(json, "kafka");
        node.amqp = JsonCompat.consumeProperty(json, "amqp");
        node.amqp1 = JsonCompat.consumeProperty(json, "amqp1");
        node.mqtt = JsonCompat.consumeProperty(json, "mqtt");
        node.mqtt5 = JsonCompat.consumeProperty(json, "mqtt5");
        node.nats = JsonCompat.consumeProperty(json, "nats");
        node.jms = JsonCompat.consumeProperty(json, "jms");
        node.sns = JsonCompat.consumeProperty(json, "sns");
        node.sqs = JsonCompat.consumeProperty(json, "sqs");
        node.stomp = JsonCompat.consumeProperty(json, "stomp");
        node.redis = JsonCompat.consumeProperty(json, "redis");
        this.readExtraProperties(json, node);
    }

    public void readOperationBindings(Object json, AaiOperationBindings node) {
        node.http = JsonCompat.consumeProperty(json, "http");
        node.ws = JsonCompat.consumeProperty(json, "ws");
        node.kafka = JsonCompat.consumeProperty(json, "kafka");
        node.amqp = JsonCompat.consumeProperty(json, "amqp");
        node.amqp1 = JsonCompat.consumeProperty(json, "amqp1");
        node.mqtt = JsonCompat.consumeProperty(json, "mqtt");
        node.mqtt5 = JsonCompat.consumeProperty(json, "mqtt5");
        node.nats = JsonCompat.consumeProperty(json, "nats");
        node.jms = JsonCompat.consumeProperty(json, "jms");
        node.sns = JsonCompat.consumeProperty(json, "sns");
        node.sqs = JsonCompat.consumeProperty(json, "sqs");
        node.stomp = JsonCompat.consumeProperty(json, "stomp");
        node.redis = JsonCompat.consumeProperty(json, "redis");
        this.readExtraProperties(json, node);
    }

    public void readServerBindings(Object json, AaiServerBindings node) {
        node.http = JsonCompat.consumeProperty(json, "http");
        node.ws = JsonCompat.consumeProperty(json, "ws");
        node.kafka = JsonCompat.consumeProperty(json, "kafka");
        node.amqp = JsonCompat.consumeProperty(json, "amqp");
        node.amqp1 = JsonCompat.consumeProperty(json, "amqp1");
        node.mqtt = JsonCompat.consumeProperty(json, "mqtt");
        node.mqtt5 = JsonCompat.consumeProperty(json, "mqtt5");
        node.nats = JsonCompat.consumeProperty(json, "nats");
        node.jms = JsonCompat.consumeProperty(json, "jms");
        node.sns = JsonCompat.consumeProperty(json, "sns");
        node.sqs = JsonCompat.consumeProperty(json, "sqs");
        node.stomp = JsonCompat.consumeProperty(json, "stomp");
        node.redis = JsonCompat.consumeProperty(json, "redis");
        this.readExtraProperties(json, node);
    }
}

