/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.combined.visitors.CombinedVisitorAdapter;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.common.SecurityRequirement;
import io.apicurio.datamodels.core.models.common.SecurityScheme;
import io.apicurio.datamodels.core.util.VisitorUtil;
import io.apicurio.datamodels.core.visitors.TraverserDirection;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20SecurityScheme;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30SecurityScheme;
import java.util.List;

public class RenameSecuritySchemeCommand
extends AbstractCommand {
    public String _oldSchemeName;
    public String _newSchemeName;

    RenameSecuritySchemeCommand() {
    }

    RenameSecuritySchemeCommand(String oldSchemeName, String newSchemeName) {
        this._oldSchemeName = oldSchemeName;
        this._newSchemeName = newSchemeName;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[RenameSecuritySchemeCommand] Executing.", new Object[0]);
        this._doSecuritySchemeRename((OasDocument)document, this._oldSchemeName, this._newSchemeName);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[RenameSecuritySchemeCommand] Reverting.", new Object[0]);
        this._doSecuritySchemeRename((OasDocument)document, this._newSchemeName, this._oldSchemeName);
    }

    private void _doSecuritySchemeRename(OasDocument document, final String from, final String to) {
        Oas30Document doc30;
        Oas20Document doc20;
        SecurityScheme scheme = null;
        if (document.is2xDocument()) {
            doc20 = (Oas20Document)document;
            if (ModelUtils.isDefined(doc20.securityDefinitions)) {
                if (ModelUtils.isDefined(doc20.securityDefinitions.getSecurityScheme(to))) {
                    return;
                }
                scheme = doc20.securityDefinitions.removeSecurityScheme(from);
            }
        } else {
            doc30 = (Oas30Document)document;
            if (ModelUtils.isDefined(doc30.components)) {
                if (!this.isNullOrUndefined(doc30.components.getSecurityScheme(to))) {
                    return;
                }
                scheme = doc30.components.removeSecurityScheme(from);
            }
        }
        if (this.isNullOrUndefined(scheme)) {
            return;
        }
        scheme.rename(to);
        if (document.is2xDocument()) {
            doc20 = (Oas20Document)document;
            doc20.securityDefinitions.addSecurityScheme(to, (Oas20SecurityScheme)scheme);
        } else {
            doc30 = (Oas30Document)document;
            doc30.components.addSecurityScheme(to, (Oas30SecurityScheme)scheme);
        }
        VisitorUtil.visitTree(document, new CombinedVisitorAdapter(){

            @Override
            public void visitSecurityRequirement(SecurityRequirement node) {
                List<String> scopes = node.removeSecurityRequirementItem(from);
                if (ModelUtils.isDefined(scopes)) {
                    node.addSecurityRequirementItem(to, scopes);
                }
            }
        }, TraverserDirection.down);
    }
}

