/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.invalid.reference;

import io.apicurio.datamodels.core.models.common.IDefinition;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.core.util.ReferenceUtil;
import io.apicurio.datamodels.core.validation.ValidationRule;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.openapi.models.IOasPropertySchema;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;

public class OasInvalidSchemaReferenceRule
extends ValidationRule {
    public OasInvalidSchemaReferenceRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitSchema(Schema node) {
        if (this.hasValue(node.$ref)) {
            this.reportIfInvalid(ReferenceUtil.canResolveRef(node.$ref, node), node, "$ref", this.map(new String[0]));
        }
    }

    @Override
    public void visitPropertySchema(IOasPropertySchema node) {
        this.visitSchema((Schema)((Object)node));
    }

    @Override
    public void visitAdditionalPropertiesSchema(OasSchema node) {
        this.visitSchema(node);
    }

    @Override
    public void visitItemsSchema(OasSchema node) {
        this.visitSchema(node);
    }

    @Override
    public void visitAllOfSchema(OasSchema node) {
        this.visitSchema(node);
    }

    @Override
    public void visitAnyOfSchema(Oas30Schema.Oas30AnyOfSchema node) {
        this.visitSchema(node);
    }

    @Override
    public void visitOneOfSchema(Oas30Schema.Oas30OneOfSchema node) {
        this.visitSchema(node);
    }

    @Override
    public void visitNotSchema(Oas30Schema.Oas30NotSchema node) {
        this.visitSchema(node);
    }

    @Override
    public void visitSchemaDefinition(IDefinition node) {
        this.visitSchema((Schema)((Object)node));
    }
}

