/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.rest;

import io.apicurio.registry.ccompat.dto.Schema;
import io.apicurio.registry.ccompat.dto.SchemaContent;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;

@Path(value="/ccompat/subjects/{subject}/versions")
@Consumes(value={"application/json", "application/octet-stream", "application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json"})
@Produces(value={"application/vnd.schemaregistry.v1+json"})
public interface SubjectVersionsResource {
    @GET
    public List<Integer> listVersions(@PathParam(value="subject") String var1) throws Exception;

    @POST
    public void register(@Suspended AsyncResponse var1, @PathParam(value="subject") String var2, @NotNull SchemaContent var3) throws Exception;

    @GET
    @Path(value="/{version}")
    public Schema getSchemaByVersion(@PathParam(value="subject") String var1, @PathParam(value="version") String var2) throws Exception;

    @DELETE
    @Path(value="/{version}")
    public int deleteSchemaVersion(@PathParam(value="subject") String var1, @PathParam(value="version") String var2) throws Exception;

    @GET
    @Path(value="/{version}/schema")
    public String getSchemaOnly(@PathParam(value="subject") String var1, @PathParam(value="version") String var2) throws Exception;

    @GET
    @Path(value="/{version}/referencedby")
    public List<Integer> getSchemasReferencedBy(@PathParam(value="subject") String var1, @PathParam(value="version") Integer var2) throws Exception;
}

