/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.store;

import io.apicurio.registry.ccompat.dto.Schema;
import io.apicurio.registry.ccompat.dto.SchemaContent;
import io.apicurio.registry.ccompat.dto.SubjectVersion;
import io.apicurio.registry.ccompat.rest.error.ConflictException;
import io.apicurio.registry.ccompat.rest.error.UnprocessableEntityException;
import io.apicurio.registry.ccompat.store.FacadeConverter;
import io.apicurio.registry.ccompat.store.RegistryStorageFacade;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.RuleApplicationType;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.RulesService;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactMetaDataDto;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.RegistryStorageException;
import io.apicurio.registry.storage.RuleConfigurationDto;
import io.apicurio.registry.storage.RuleNotFoundException;
import io.apicurio.registry.storage.StoredArtifact;
import io.apicurio.registry.storage.VersionNotFoundException;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RuleType;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class RegistryStorageFacadeImpl
implements RegistryStorageFacade {
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    RulesService rulesService;

    @Override
    public List<String> getSubjects() {
        return new ArrayList<String>(this.storage.getArtifactIds());
    }

    @Override
    public List<SubjectVersion> getSubjectVersions(int globalId) {
        String artifactId = this.storage.getArtifactMetaData(globalId).getId();
        return this.storage.getArtifactVersions(artifactId).stream().map(version -> FacadeConverter.convert(artifactId, version)).collect(Collectors.toList());
    }

    @Override
    public List<Integer> deleteSubject(String subject) throws ArtifactNotFoundException, RegistryStorageException {
        return this.storage.deleteArtifact(subject).stream().map(FacadeConverter::convertUnsigned).collect(Collectors.toList());
    }

    @Override
    public SchemaContent getSchemaContent(int globalId) throws ArtifactNotFoundException, RegistryStorageException {
        return FacadeConverter.convert(this.storage.getArtifactVersion(globalId), this.storage.getArtifactMetaData(globalId).getType());
    }

    @Override
    public Schema getSchema(String subject, String versionString) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        return this.parseVersionString(subject, versionString, version -> FacadeConverter.convert(subject, this.storage.getArtifactVersion(subject, (long)version)));
    }

    @Override
    public List<Integer> getVersions(String subject) throws ArtifactNotFoundException, RegistryStorageException {
        return this.storage.getArtifactVersions(subject).stream().map(FacadeConverter::convertUnsigned).collect(Collectors.toList());
    }

    @Override
    public Schema getSchema(String subject, SchemaContent schema) throws ArtifactNotFoundException, RegistryStorageException {
        ArtifactMetaDataDto amd = this.storage.getArtifactMetaData(subject, ContentHandle.create(schema.getSchema()));
        StoredArtifact storedArtifact = this.storage.getArtifactVersion(subject, amd.getVersion());
        return FacadeConverter.convert(subject, storedArtifact);
    }

    @Override
    public CompletionStage<Long> createSchema(String subject, String schema, String schemaType) throws ArtifactAlreadyExistsException, ArtifactNotFoundException, RegistryStorageException {
        CompletionStage<ArtifactMetaDataDto> artifactMeta = this.createOrUpdateArtifact(subject, schema, ArtifactType.fromValue(schemaType));
        return artifactMeta.thenApply(ArtifactMetaDataDto::getGlobalId);
    }

    @Override
    public int deleteSchema(String subject, String versionString) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        return FacadeConverter.convertUnsigned(this.parseVersionString(subject, versionString, version -> {
            this.storage.deleteArtifactVersion(subject, (long)version);
            return version;
        }));
    }

    @Override
    public void createOrUpdateArtifactRule(String subject, RuleType type, RuleConfigurationDto dto) {
        if (!this.doesArtifactRuleExist(subject, RuleType.COMPATIBILITY)) {
            this.storage.createArtifactRule(subject, RuleType.COMPATIBILITY, dto);
        } else {
            this.storage.updateArtifactRule(subject, RuleType.COMPATIBILITY, dto);
        }
    }

    @Override
    public void createOrUpdateGlobalRule(RuleType type, RuleConfigurationDto dto) {
        if (!this.doesGlobalRuleExist(RuleType.COMPATIBILITY)) {
            this.storage.createGlobalRule(RuleType.COMPATIBILITY, dto);
        } else {
            this.storage.updateGlobalRule(RuleType.COMPATIBILITY, dto);
        }
    }

    private CompletionStage<ArtifactMetaDataDto> createOrUpdateArtifact(String subject, String schema, ArtifactType artifactType) {
        CompletionStage<ArtifactMetaDataDto> res;
        try {
            if (!this.doesArtifactExist(subject)) {
                this.rulesService.applyRules(subject, ArtifactType.AVRO, ContentHandle.create(schema), RuleApplicationType.CREATE);
                res = this.storage.createArtifact(subject, ArtifactType.AVRO, ContentHandle.create(schema));
            } else {
                this.rulesService.applyRules(subject, artifactType, ContentHandle.create(schema), RuleApplicationType.UPDATE);
                res = this.storage.updateArtifact(subject, artifactType, ContentHandle.create(schema));
            }
        }
        catch (RuleViolationException ex) {
            if (ex.getRuleType() == RuleType.VALIDITY) {
                throw new UnprocessableEntityException(ex.getMessage(), ex);
            }
            throw new ConflictException(ex.getMessage(), ex);
        }
        return res;
    }

    @Override
    public <T> T parseVersionString(String subject, String versionString, Function<Long, T> then) {
        long version;
        if ("latest".equals(versionString)) {
            SortedSet<Long> versions = this.storage.getArtifactVersions(subject);
            version = versions.last();
        } else {
            try {
                version = Integer.parseUnsignedInt(versionString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Illegal version format: " + versionString, e);
            }
        }
        return then.apply(version);
    }

    @Override
    public RuleConfigurationDto getGlobalRule(RuleType ruleType) {
        return this.storage.getGlobalRule(ruleType);
    }

    @Override
    public void deleteGlobalRule(RuleType ruleType) {
        this.storage.deleteGlobalRule(ruleType);
    }

    @Override
    public void deleteArtifactRule(String subject, RuleType ruleType) {
        this.storage.deleteArtifactRule(subject, ruleType);
    }

    @Override
    public RuleConfigurationDto getArtifactRule(String subject, RuleType ruleType) {
        return this.storage.getArtifactRule(subject, ruleType);
    }

    private boolean doesArtifactExist(String artifactId) {
        try {
            this.storage.getArtifact(artifactId);
            return true;
        }
        catch (ArtifactNotFoundException ignored) {
            return false;
        }
    }

    private boolean doesArtifactRuleExist(String artifactId, RuleType type) {
        try {
            this.storage.getArtifactRule(artifactId, type);
            return true;
        }
        catch (RuleNotFoundException ignored) {
            return false;
        }
    }

    private boolean doesGlobalRuleExist(RuleType type) {
        try {
            this.storage.getGlobalRule(type);
            return true;
        }
        catch (RuleNotFoundException ignored) {
            return false;
        }
    }
}

