/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.client;

import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.rest.beans.ArtifactMetaData;
import io.apicurio.registry.rest.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.beans.EditableMetaData;
import io.apicurio.registry.rest.beans.IfExistsType;
import io.apicurio.registry.rest.beans.Rule;
import io.apicurio.registry.rest.beans.SearchOver;
import io.apicurio.registry.rest.beans.SortOrder;
import io.apicurio.registry.rest.beans.UpdateState;
import io.apicurio.registry.rest.beans.VersionMetaData;
import io.apicurio.registry.rest.beans.VersionSearchResults;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.IoUtil;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.Vetoed;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Vetoed
@Path(value="__dummy_hack_apicurio")
class CachedRegistryService
implements RegistryService {
    private final RegistryService delegate;
    private final Map<String, Map<String, ArtifactMetaData>> cmds = new ConcurrentHashMap<String, Map<String, ArtifactMetaData>>();
    private final Map<String, Map<Integer, VersionMetaData>> vmds = new ConcurrentHashMap<String, Map<Integer, VersionMetaData>>();
    private final Map<Long, ArtifactMetaData> globalAMD = new ConcurrentHashMap<Long, ArtifactMetaData>();

    public CachedRegistryService() {
        this.delegate = null;
    }

    public CachedRegistryService(RegistryService delegate) {
        this.delegate = delegate;
    }

    private RegistryService getDelegate() {
        if (this.delegate == null) {
            throw new IllegalStateException("Null registry service delegate!");
        }
        return this.delegate;
    }

    @Override
    public void reset() {
        this.cmds.clear();
        this.vmds.clear();
        this.globalAMD.clear();
    }

    @Override
    public ArtifactMetaData getArtifactMetaData(String artifactId) {
        ArtifactMetaData amd = this.getDelegate().getArtifactMetaData(artifactId);
        this.globalAMD.put(amd.getGlobalId(), amd);
        return amd;
    }

    @Override
    public ArtifactMetaData getArtifactMetaDataByContent(String artifactId, InputStream data) {
        String content = IoUtil.toString(data);
        Map map = this.cmds.computeIfAbsent(artifactId, id -> new ConcurrentHashMap());
        return map.computeIfAbsent(content, c -> {
            InputStream copy = IoUtil.toStream(content);
            ArtifactMetaData amd = this.getDelegate().getArtifactMetaDataByContent(artifactId, copy);
            this.globalAMD.put(amd.getGlobalId(), amd);
            return amd;
        });
    }

    @Override
    public ArtifactMetaData getArtifactMetaDataByGlobalId(long globalId) {
        return this.globalAMD.computeIfAbsent(globalId, this.getDelegate()::getArtifactMetaDataByGlobalId);
    }

    @Override
    public VersionMetaData getArtifactVersionMetaData(Integer version, String artifactId) {
        Map map = this.vmds.computeIfAbsent(artifactId, id -> new ConcurrentHashMap());
        return map.computeIfAbsent(version, v -> this.getDelegate().getArtifactVersionMetaData(version, artifactId));
    }

    @Override
    public CompletionStage<ArtifactMetaData> createArtifact(ArtifactType xRegistryArtifactType, String xRegistryArtifactId, IfExistsType ifExists, InputStream data) {
        CompletionStage<ArtifactMetaData> cs = this.getDelegate().createArtifact(xRegistryArtifactType, xRegistryArtifactId, ifExists, data);
        return cs.thenApply(amd -> {
            this.globalAMD.put(amd.getGlobalId(), (ArtifactMetaData)amd);
            return amd;
        });
    }

    @Override
    public List<String> listArtifacts() {
        return this.getDelegate().listArtifacts();
    }

    @Override
    public CompletionStage<ArtifactMetaData> updateArtifact(String artifactId, ArtifactType xRegistryArtifactType, InputStream data) {
        CompletionStage<ArtifactMetaData> cs = this.getDelegate().updateArtifact(artifactId, xRegistryArtifactType, data);
        return cs.thenApply(amd -> {
            this.globalAMD.put(amd.getGlobalId(), (ArtifactMetaData)amd);
            return amd;
        });
    }

    @Override
    public CompletionStage<VersionMetaData> createArtifactVersion(String artifactId, ArtifactType xRegistryArtifactType, InputStream data) {
        CompletionStage<VersionMetaData> cs = this.getDelegate().createArtifactVersion(artifactId, xRegistryArtifactType, data);
        return cs.thenApply(vmd -> {
            Map map = this.vmds.computeIfAbsent(artifactId, id -> new ConcurrentHashMap());
            map.put(vmd.getVersion(), vmd);
            return vmd;
        });
    }

    @Override
    public Response getLatestArtifact(String artifactId) {
        ArtifactMetaData amd = this.getArtifactMetaData(artifactId);
        return this.getArtifactVersion(amd.getVersion(), amd.getId());
    }

    @Override
    public Response getArtifactVersion(Integer version, String artifactId) {
        return this.getDelegate().getArtifactVersion(version, artifactId);
    }

    @Override
    public Response getArtifactByGlobalId(long globalId) {
        return this.getDelegate().getArtifactByGlobalId(globalId);
    }

    @Override
    public void testUpdateArtifact(String artifactId, ArtifactType xRegistryArtifactType, InputStream content) {
        this.getDelegate().testUpdateArtifact(artifactId, xRegistryArtifactType, content);
    }

    @Override
    public List<Long> listArtifactVersions(String artifactId) {
        return this.getDelegate().listArtifactVersions(artifactId);
    }

    @Override
    public void updateArtifactState(String artifactId, UpdateState data) {
        this.getDelegate().updateArtifactState(artifactId, data);
        this.reset();
    }

    @Override
    public void updateArtifactVersionState(Integer version, String artifactId, UpdateState data) {
        this.getDelegate().updateArtifactVersionState(version, artifactId, data);
        this.reset();
    }

    @Override
    public void deleteArtifact(String artifactId) {
        this.getDelegate().deleteArtifact(artifactId);
        this.reset();
    }

    @Override
    public void updateArtifactMetaData(String artifactId, EditableMetaData data) {
        this.getDelegate().updateArtifactMetaData(artifactId, data);
        this.reset();
    }

    @Override
    public void deleteArtifactVersionMetaData(Integer version, String artifactId) {
        this.getDelegate().deleteArtifactVersionMetaData(version, artifactId);
        this.reset();
    }

    @Override
    public void updateArtifactVersionMetaData(Integer version, String artifactId, EditableMetaData data) {
        this.getDelegate().updateArtifactVersionMetaData(version, artifactId, data);
        this.reset();
    }

    @Override
    public Rule getArtifactRuleConfig(RuleType rule, String artifactId) {
        return this.getDelegate().getArtifactRuleConfig(rule, artifactId);
    }

    @Override
    public Rule updateArtifactRuleConfig(RuleType rule, String artifactId, Rule data) {
        return this.getDelegate().updateArtifactRuleConfig(rule, artifactId, data);
    }

    @Override
    public void deleteArtifactRule(RuleType rule, String artifactId) {
        this.getDelegate().deleteArtifactRule(rule, artifactId);
    }

    @Override
    public List<RuleType> listArtifactRules(String artifactId) {
        return this.getDelegate().listArtifactRules(artifactId);
    }

    @Override
    public void createArtifactRule(String artifactId, Rule data) {
        this.getDelegate().createArtifactRule(artifactId, data);
    }

    @Override
    public void deleteArtifactRules(String artifactId) {
        this.getDelegate().deleteArtifactRules(artifactId);
    }

    @Override
    public Rule getGlobalRuleConfig(RuleType rule) {
        return this.getDelegate().getGlobalRuleConfig(rule);
    }

    @Override
    public Rule updateGlobalRuleConfig(RuleType rule, Rule data) {
        return this.getDelegate().updateGlobalRuleConfig(rule, data);
    }

    @Override
    public void deleteGlobalRule(RuleType rule) {
        this.getDelegate().deleteGlobalRule(rule);
    }

    @Override
    public List<RuleType> listGlobalRules() {
        return this.getDelegate().listGlobalRules();
    }

    @Override
    public void createGlobalRule(Rule data) {
        this.getDelegate().createGlobalRule(data);
    }

    @Override
    public void deleteAllGlobalRules() {
        this.getDelegate().deleteAllGlobalRules();
    }

    @Override
    public void close() throws Exception {
        this.getDelegate().close();
    }

    @Override
    public ArtifactSearchResults searchArtifacts(String search, Integer offset, Integer limit, SearchOver over, SortOrder order) {
        return this.getDelegate().searchArtifacts(search, offset, limit, over, order);
    }

    @Override
    public VersionSearchResults searchVersions(String artifactId, Integer offset, Integer limit) {
        return this.getDelegate().searchVersions(artifactId, offset, limit);
    }
}

