/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content;

import io.apicurio.registry.content.AbstractContentHandle;
import io.apicurio.registry.utils.IoBufferedInputStream;
import io.apicurio.registry.utils.IoUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

class StreamContentHandle
extends AbstractContentHandle {
    private InputStream stream;

    StreamContentHandle(InputStream stream) {
        this.stream = stream;
    }

    @Override
    public InputStream stream() {
        if (this.bytes != null) {
            return new ByteArrayInputStream(this.bytes);
        }
        InputStream is = this.stream;
        this.stream = null;
        return new IoBufferedInputStream(is, (bytes, count) -> {
            byte[] copy = new byte[count.intValue()];
            System.arraycopy(bytes, 0, copy, 0, count);
            this.bytes = copy;
        });
    }

    @Override
    public byte[] bytes() {
        if (this.bytes == null) {
            InputStream is = this.stream;
            this.stream = null;
            this.bytes = IoUtil.toBytes(is);
        }
        return this.bytes;
    }

    @Override
    public String content() {
        if (this.content == null) {
            this.content = new String(this.bytes(), StandardCharsets.UTF_8);
        }
        return this.content;
    }
}

