/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.canon;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.canon.ContentCanonicalizer;
import io.apicurio.registry.utils.IoUtil;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.xml.sax.SAXException;

public class XmlContentCanonicalizer
implements ContentCanonicalizer {
    private static ThreadLocal<Canonicalizer> xmlCanonicalizer = new ThreadLocal<Canonicalizer>(){

        @Override
        protected Canonicalizer initialValue() {
            try {
                return Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            }
            catch (InvalidCanonicalizerException e) {
                throw new RuntimeException(e);
            }
        }
    };

    @Override
    public ContentHandle canonicalize(ContentHandle content) {
        try {
            Canonicalizer canon = xmlCanonicalizer.get();
            String canonicalized = IoUtil.toString(canon.canonicalize(content.bytes()));
            return ContentHandle.create(canonicalized);
        }
        catch (IOException | ParserConfigurationException | CanonicalizationException | SAXException throwable) {
            return content;
        }
    }

    static {
        Init.init();
    }
}

