/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.extract;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.combined.visitors.CombinedVisitorAdapter;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.common.Info;
import io.apicurio.datamodels.core.visitors.TraverserDirection;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.extract.ContentExtractor;
import io.apicurio.registry.rest.beans.EditableMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiOrAsyncApiContentExtractor
implements ContentExtractor {
    private static final Logger log = LoggerFactory.getLogger(OpenApiOrAsyncApiContentExtractor.class);
    public static final ContentExtractor INSTANCE = new OpenApiOrAsyncApiContentExtractor();

    private OpenApiOrAsyncApiContentExtractor() {
    }

    @Override
    public EditableMetaData extract(ContentHandle content) {
        try {
            Document openApi = Library.readDocumentFromJSONString(content.content());
            MetaDataVisitor viz = new MetaDataVisitor();
            Library.visitTree(openApi, viz, TraverserDirection.down);
            EditableMetaData metaData = null;
            if (viz.name != null || viz.description != null) {
                metaData = new EditableMetaData();
            }
            if (viz.name != null) {
                metaData.setName(viz.name);
            }
            if (viz.description != null) {
                metaData.setDescription(viz.description);
            }
            return metaData;
        }
        catch (Exception e) {
            log.warn("Error extracting metadata from Open/Async API: {}", (Object)e.getMessage());
            return null;
        }
    }

    private static class MetaDataVisitor
    extends CombinedVisitorAdapter {
        String name;
        String description;

        private MetaDataVisitor() {
        }

        @Override
        public void visitInfo(Info node) {
            this.name = node.title;
            this.description = node.description;
        }
    }
}

