/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ibmcompat.api.impl;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.ibmcompat.api.ApiService;
import io.apicurio.registry.ibmcompat.model.AnyOfStateModificationEnabledModification;
import io.apicurio.registry.ibmcompat.model.NewSchema;
import io.apicurio.registry.ibmcompat.model.NewSchemaVersion;
import io.apicurio.registry.ibmcompat.model.Schema;
import io.apicurio.registry.ibmcompat.model.SchemaInfo;
import io.apicurio.registry.ibmcompat.model.SchemaListItem;
import io.apicurio.registry.ibmcompat.model.SchemaSummary;
import io.apicurio.registry.ibmcompat.model.SchemaVersion;
import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.rules.RuleApplicationType;
import io.apicurio.registry.rules.RulesService;
import io.apicurio.registry.storage.ArtifactMetaDataDto;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.StoredArtifact;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.util.ArtifactIdGenerator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;

@ApplicationScoped
@Logged
public class ApiServiceImpl
implements ApiService {
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    RulesService rulesService;
    @Inject
    ArtifactIdGenerator idGenerator;

    private List<SchemaVersion> getSchemaVersions(String schemaid) {
        return this.storage.getArtifactVersions(schemaid).stream().map(l -> {
            SchemaVersion sv = new SchemaVersion();
            sv.setId(l.intValue());
            sv.setEnabled(true);
            return sv;
        }).collect(Collectors.toList());
    }

    @Override
    public List<SchemaListItem> apiSchemasGet(int page, int perPage) throws ArtifactNotFoundException {
        TreeSet<String> ids = new TreeSet<String>(this.storage.getArtifactIds());
        return ids.stream().skip(page * perPage).limit(perPage).map(id -> {
            SchemaListItem item = new SchemaListItem();
            try {
                StoredArtifact artifact = this.storage.getArtifact((String)id);
                item.setId((String)id);
                item.setEnabled(true);
                SchemaVersion version = new SchemaVersion();
                version.setId(artifact.getVersion().intValue());
                item.setLatest(version);
            }
            catch (ArtifactNotFoundException artifactNotFoundException) {
                // empty catch block
            }
            return item;
        }).filter(SchemaSummary::isEnabled).collect(Collectors.toList());
    }

    @Override
    public void apiSchemasPost(AsyncResponse response, NewSchema schema, boolean verify) throws ArtifactNotFoundException {
        String artifactId = schema.getName();
        if (artifactId == null) {
            artifactId = this.idGenerator.generate();
        }
        ContentHandle content = ContentHandle.create(schema.getDefinition());
        if (verify) {
            this.rulesService.applyRules(artifactId, ArtifactType.AVRO, content, RuleApplicationType.CREATE);
            response.resume((Object)Response.ok().entity((Object)content).build());
        } else {
            CompletionStage<ArtifactMetaDataDto> csArtifact = this.storage.createArtifact(artifactId, ArtifactType.AVRO, content);
            csArtifact.whenComplete((amdd, t) -> {
                if (t != null) {
                    response.resume(t);
                } else {
                    SchemaInfo info = new SchemaInfo();
                    info.setId(amdd.getId());
                    info.setEnabled(true);
                    info.setVersions(this.getSchemaVersions(amdd.getId()));
                    response.resume((Object)Response.status((Response.Status)Response.Status.CREATED).entity((Object)info).build());
                }
            });
        }
    }

    @Override
    public Response apiSchemasSchemaidDelete(String schemaid) throws ArtifactNotFoundException {
        SortedSet<Long> ids = this.storage.deleteArtifact(schemaid);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).entity(ids).build();
    }

    @Override
    public SchemaInfo apiSchemasSchemaidGet(String schemaid) throws ArtifactNotFoundException {
        this.storage.getArtifact(schemaid);
        SchemaInfo info = new SchemaInfo();
        info.setId(schemaid);
        info.setEnabled(true);
        info.setVersions(this.getSchemaVersions(schemaid));
        return info;
    }

    @Override
    public Response apiSchemasSchemaidPatch(String schemaid, List<AnyOfStateModificationEnabledModification> anyOfStateModificationEnabledModification) throws ArtifactNotFoundException {
        return Response.ok().entity((Object)"OK").build();
    }

    @Override
    public void apiSchemasSchemaidVersionsPost(AsyncResponse response, String schemaid, NewSchemaVersion schema, boolean verify) throws ArtifactNotFoundException {
        ContentHandle body = ContentHandle.create(schema.getDefinition());
        if (verify) {
            this.rulesService.applyRules(schemaid, ArtifactType.AVRO, body, RuleApplicationType.UPDATE);
            response.resume((Object)Response.ok().entity((Object)body).build());
        } else {
            CompletionStage<ArtifactMetaDataDto> csArtifact = this.storage.updateArtifact(schemaid, ArtifactType.AVRO, body);
            csArtifact.whenComplete((amdd, t) -> {
                if (t != null) {
                    response.resume(t);
                } else {
                    SchemaInfo info = new SchemaInfo();
                    info.setId(amdd.getId());
                    info.setEnabled(true);
                    info.setVersions(this.getSchemaVersions(amdd.getId()));
                    response.resume((Object)Response.status((Response.Status)Response.Status.CREATED).entity((Object)info).build());
                }
            });
        }
    }

    @Override
    public Response apiSchemasSchemaidVersionsVersionnumDelete(String schemaid, int versionnum) throws ArtifactNotFoundException {
        this.storage.deleteArtifactVersion(schemaid, versionnum);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @Override
    public Schema apiSchemasSchemaidVersionsVersionnumGet(String schemaid, int versionnum) throws ArtifactNotFoundException {
        StoredArtifact artifact = this.storage.getArtifactVersion(schemaid, versionnum);
        Schema schema = new Schema();
        schema.setId(schemaid);
        schema.setEnabled(true);
        schema.setDefinition(artifact.getContent().content());
        SchemaVersion version = new SchemaVersion();
        version.setId(artifact.getVersion().intValue());
        schema.setVersion(version);
        return schema;
    }

    @Override
    public Response apiSchemasSchemaidVersionsVersionnumPatch(String schemaid, int versionnum, List<AnyOfStateModificationEnabledModification> anyOfStateModificationEnabledModification) throws ArtifactNotFoundException {
        return Response.ok().entity((Object)"OK").build();
    }
}

