/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.infinispan;

import io.apicurio.registry.infinispan.MapValue;
import io.apicurio.registry.storage.impl.MultiMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.util.function.SerializableBiFunction;

class CacheMultiMap<K extends Serializable, MK extends Serializable, MV extends Serializable>
implements MultiMap<K, MK, MV> {
    private final Cache<K, MapValue<MK, MV>> cache;

    public CacheMultiMap(Cache<K, MapValue<MK, MV>> cache) {
        this.cache = cache;
    }

    private Map<MK, MV> get(K key) {
        MapValue map = (MapValue)this.cache.get(key);
        return map != null ? map.getMap() : Collections.emptyMap();
    }

    @Override
    public Set<MK> keys(K key) {
        return this.get(key).keySet();
    }

    @Override
    public MV get(K key, MK mk) {
        return (MV)((Serializable)this.get(key).get(mk));
    }

    @Override
    public MV putIfPresent(K key, MK mk, MV mv) {
        MapValue cMap = (MapValue)this.cache.compute(key, (SerializableBiFunction & Serializable)(k, value) -> {
            if (value == null) {
                return null;
            }
            Map<Serializable, Serializable> map = value.getMap();
            Serializable pmv = (Serializable)map.get(mk);
            if (pmv != null) {
                map.put((Serializable)mk, (Serializable)mv);
            }
            value.setValue(pmv);
            return value;
        });
        return cMap != null ? (MV)cMap.getValue() : null;
    }

    @Override
    public MV putIfAbsent(K key, MK mk, MV mv) {
        MapValue cMap = (MapValue)this.cache.compute(key, (SerializableBiFunction & Serializable)(k, value) -> {
            if (value == null) {
                value = new MapValue(new HashMap(), null);
            }
            Map<Serializable, Serializable> map = value.getMap();
            value.setValue(map.putIfAbsent((Serializable)mk, (Serializable)mv));
            return value;
        });
        return cMap != null ? (MV)cMap.getValue() : null;
    }

    @Override
    public MV remove(K key, MK mk) {
        MapValue cMap = (MapValue)this.cache.compute(key, (SerializableBiFunction & Serializable)(k, value) -> {
            if (value == null) {
                return null;
            }
            Map map = value.getMap();
            value.setValue((Serializable)map.remove(mk));
            return value;
        });
        return cMap != null ? (MV)cMap.getValue() : null;
    }

    @Override
    public void remove(K key) {
        this.cache.remove(key);
    }

    @Override
    public void putAll(Map<K, Map<MK, MV>> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<K, Map<MK, MV>> asMap() {
        throw new UnsupportedOperationException();
    }
}

