/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.infinispan;

import io.apicurio.registry.infinispan.InfinispanRegistryStorage;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.ArtifactStateExt;
import io.apicurio.registry.storage.MetaDataKeys;
import io.apicurio.registry.storage.VersionNotFoundException;
import io.apicurio.registry.storage.impl.AbstractMapRegistryStorage;
import io.apicurio.registry.storage.impl.StorageMap;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.utils.ConcurrentUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.util.UserRaisedFunctionalException;
import org.infinispan.util.function.SerializableBiFunction;
import org.infinispan.util.function.SerializableFunction;

class CacheStorageMap
implements StorageMap {
    private static final Set<Class<? extends Throwable>> INFINISPAN_EXCEPTIONS = new HashSet<Class<? extends Throwable>>();
    private final Cache<String, Map<Long, Map<String, String>>> cache;

    private CacheStorageMap(Cache<String, Map<Long, Map<String, String>>> cache) {
        this.cache = cache;
    }

    public static StorageMap create(Cache<String, Map<Long, Map<String, String>>> cache) {
        CacheStorageMap delegate = new CacheStorageMap(cache);
        return (StorageMap)Proxy.newProxyInstance(CacheStorageMap.class.getClassLoader(), new Class[]{StorageMap.class}, (proxy, method, args) -> {
            try {
                return method.invoke((Object)delegate, args);
            }
            catch (InvocationTargetException e) {
                Throwable cause;
                Throwable top = cause = e.getCause();
                while (CacheStorageMap.isInfinispanException(cause)) {
                    cause = cause.getCause();
                }
                throw cause != null ? cause : top;
            }
        });
    }

    private static boolean isInfinispanException(Throwable t) {
        if (t == null) {
            return false;
        }
        return INFINISPAN_EXCEPTIONS.stream().anyMatch(c -> c.isInstance(t));
    }

    @Override
    public Map<String, Map<Long, Map<String, String>>> asMap() {
        return this.cache;
    }

    @Override
    public void putAll(Map<String, Map<Long, Map<String, String>>> map) {
        this.cache.putAll(map);
    }

    @Override
    public Set<String> keySet() {
        return this.cache.keySet();
    }

    @Override
    public Map<Long, Map<String, String>> get(String artifactId) {
        return (Map)this.cache.get((Object)artifactId);
    }

    @Override
    public Map<Long, Map<String, String>> compute(String artifactId) {
        return (Map)this.cache.compute((Object)artifactId, (SerializableBiFunction & Serializable)(k, map) -> map != null ? map : new ConcurrentHashMap());
    }

    @Override
    public void createVersion(String artifactId, long version, Map<String, String> contents) {
        this.cache.compute((Object)artifactId, (SerializableBiFunction & Serializable)(k, map) -> {
            if (map == null) {
                map = new ConcurrentHashMap<Long, Map>();
            }
            long iv = version;
            Map inner = map.putIfAbsent(iv, contents);
            while (inner != null) {
                contents.put(MetaDataKeys.VERSION, Long.toString(++iv));
                inner = map.putIfAbsent(iv, contents);
            }
            return map;
        });
    }

    static SortedSet<Long> versions(SortedSet<Long> versions) {
        versions.remove(Long.MIN_VALUE);
        return versions;
    }

    @Override
    public void put(String artifactId, String key, String value) {
        this.cache.compute((Object)artifactId, (SerializableBiFunction & Serializable)(s, map) -> {
            if (map == null) {
                throw new ArtifactNotFoundException(artifactId);
            }
            long version = map.entrySet().stream().filter(AbstractMapRegistryStorage.statesFilter(ArtifactStateExt.ACTIVE_STATES)).map(Map.Entry::getKey).max(Long::compareTo).orElseThrow(() -> new ArtifactNotFoundException(artifactId));
            Map content = (Map)map.get(version);
            if (!key.equals(MetaDataKeys.STATE)) {
                ArtifactState state = ArtifactStateExt.getState(content);
                ArtifactStateExt.validateState(ArtifactStateExt.ACTIVE_STATES, state, artifactId, version);
            }
            content.put(key, value);
            return map;
        });
    }

    @Override
    public void put(String artifactId, long version, String key, String value) {
        this.cache.compute((Object)artifactId, (SerializableBiFunction & Serializable)(s, map) -> {
            if (map == null) {
                throw new ArtifactNotFoundException(artifactId);
            }
            Map content = (Map)map.get(version);
            if (content == null) {
                throw new VersionNotFoundException(artifactId, version);
            }
            if (!key.equals(MetaDataKeys.STATE)) {
                ArtifactState state = ArtifactStateExt.getState(content);
                ArtifactStateExt.validateState(ArtifactStateExt.ACTIVE_STATES, state, artifactId, version);
            }
            content.put(key, value);
            return map;
        });
    }

    @Override
    public Long remove(String artifactId, long version) {
        HashSet result = new HashSet();
        ClusterExecutor ce = this.cache.getCacheManager().executor();
        CompletableFuture cf = ce.allNodeSubmission().submitConsumer((SerializableFunction & Serializable)manager -> {
            Cache c = manager.getCache(InfinispanRegistryStorage.STORAGE_CACHE);
            Map iMap = (Map)c.get((Object)artifactId);
            if (iMap != null) {
                Map remove = (Map)iMap.remove(version);
                if (remove == null) {
                    throw new VersionNotFoundException(artifactId, version);
                }
                return Long.parseLong((String)remove.get(MetaDataKeys.GLOBAL_ID));
            }
            throw new ArtifactNotFoundException(artifactId);
        }, (address, globalId, throwable) -> result.add(globalId));
        ConcurrentUtil.get(cf, 30L, TimeUnit.SECONDS);
        if (result.isEmpty()) {
            throw new VersionNotFoundException(artifactId, version);
        }
        return (Long)result.iterator().next();
    }

    @Override
    public void remove(String artifactId, long version, String key) {
        this.cache.compute((Object)artifactId, (SerializableBiFunction & Serializable)(k, iMap) -> {
            Map vMap;
            if (iMap != null) {
                vMap = (Map)iMap.get(version);
                if (vMap == null) {
                    throw new VersionNotFoundException(artifactId, version);
                }
            } else {
                throw new ArtifactNotFoundException(artifactId);
            }
            vMap.remove(key);
            return iMap;
        });
    }

    @Override
    public Map<Long, Map<String, String>> remove(String artifactId) {
        return (Map)this.cache.remove((Object)artifactId);
    }

    static {
        INFINISPAN_EXCEPTIONS.add(CacheException.class);
        INFINISPAN_EXCEPTIONS.add(UserRaisedFunctionalException.class);
    }
}

