/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.infinispan;

import io.apicurio.registry.infinispan.MapValue;
import io.apicurio.registry.storage.impl.TupleId;
import io.apicurio.registry.utils.RegistryProperties;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;

@ApplicationScoped
public class InfinispanConfiguration {
    @ConfigProperty(name="registry.infinispan.cluster.name", defaultValue="apicurio-registry")
    String clusterName;

    @ApplicationScoped
    @Produces
    public EmbeddedCacheManager cacheManager(@RegistryProperties(value="registry.infinispan.transport.") Properties properties) {
        GlobalConfigurationBuilder gConf = GlobalConfigurationBuilder.defaultClusteredBuilder();
        gConf.serialization().marshaller((Marshaller)new JavaSerializationMarshaller()).whiteList().addRegexps(new String[]{"io.apicurio.registry.storage.", TupleId.class.getName(), MapValue.class.getName()});
        TransportConfigurationBuilder tConf = gConf.transport();
        tConf.clusterName(this.clusterName);
        if (properties.size() > 0) {
            tConf.withProperties(properties);
        }
        return new DefaultCacheManager(gConf.build(), true);
    }

    public void stop(@Disposes EmbeddedCacheManager manager) {
        manager.stop();
    }
}

