/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.infinispan;

import io.apicurio.registry.infinispan.CacheMultiMap;
import io.apicurio.registry.infinispan.CacheStorageMap;
import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.metrics.PersistenceExceptionLivenessApply;
import io.apicurio.registry.metrics.PersistenceTimeoutReadinessApply;
import io.apicurio.registry.storage.impl.AbstractMapRegistryStorage;
import io.apicurio.registry.storage.impl.MultiMap;
import io.apicurio.registry.storage.impl.StorageMap;
import io.apicurio.registry.storage.impl.TupleId;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Timed;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.health.ClusterHealth;
import org.infinispan.health.HealthStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.function.SerializableBiFunction;

@ApplicationScoped
@PersistenceExceptionLivenessApply
@PersistenceTimeoutReadinessApply
@Counted(name="storage_operation_count_InfinispanRegistryStorage", description="Total number of storage operations.", tags={"group=STORAGE", "metric=storage_operation_count"}, reusable=true)
@ConcurrentGauge(name="concurrent_operation_count_InfinispanRegistryStorage", description="Number of concurrent storage operations.", tags={"group=STORAGE", "metric=concurrent_operation_count"}, reusable=true)
@Timed(name="storage_operation_time_InfinispanRegistryStorage", description="Time for a storage operation to process.", tags={"group=STORAGE", "metric=storage_operation_time"}, unit="milliseconds", reusable=true)
@Logged
public class InfinispanRegistryStorage
extends AbstractMapRegistryStorage {
    static String KEY = "_ck";
    static String COUNTER_CACHE = "counter-cache";
    static String STORAGE_CACHE = "storage-cache";
    static String ARTIFACT_RULES_CACHE = "artifact-rules-cache";
    static String GLOBAL_CACHE = "global-cache";
    static String GLOBAL_RULES_CACHE = "global-rules-cache";
    @Inject
    EmbeddedCacheManager manager;
    private Map<String, Long> counter;

    @Override
    protected void afterInit() {
        this.manager.defineConfiguration(COUNTER_CACHE, new ConfigurationBuilder().clustering().cacheMode(CacheMode.REPL_SYNC).build());
        this.counter = this.manager.getCache(COUNTER_CACHE, true);
    }

    @Override
    protected long nextGlobalId() {
        return this.counter.compute(KEY, (BiFunction<String, Long, Long>)(SerializableBiFunction & Serializable)(k, v) -> v == null ? 1L : v + 1L);
    }

    @Override
    protected StorageMap createStorageMap() {
        this.manager.defineConfiguration(STORAGE_CACHE, new ConfigurationBuilder().clustering().cacheMode(CacheMode.REPL_SYNC).build());
        Cache cache = this.manager.getCache(STORAGE_CACHE, true);
        return CacheStorageMap.create((Cache<String, Map<Long, Map<String, String>>>)cache);
    }

    @Override
    protected Map<Long, TupleId> createGlobalMap() {
        this.manager.defineConfiguration(GLOBAL_CACHE, new ConfigurationBuilder().clustering().cacheMode(CacheMode.REPL_SYNC).build());
        return this.manager.getCache(GLOBAL_CACHE, true);
    }

    @Override
    protected Map<String, String> createGlobalRulesMap() {
        this.manager.defineConfiguration(GLOBAL_RULES_CACHE, new ConfigurationBuilder().clustering().cacheMode(CacheMode.REPL_SYNC).build());
        return this.manager.getCache(GLOBAL_RULES_CACHE, true);
    }

    @Override
    protected MultiMap<String, String, String> createArtifactRulesMap() {
        this.manager.defineConfiguration(ARTIFACT_RULES_CACHE, new ConfigurationBuilder().clustering().cacheMode(CacheMode.REPL_SYNC).build());
        Cache cache = this.manager.getCache(ARTIFACT_RULES_CACHE, true);
        return new CacheMultiMap<String, String, String>(cache);
    }

    @Override
    protected BiFunction<String, Map<Long, Map<String, String>>, Map<Long, Map<String, String>>> lookupFn() {
        return (SerializableBiFunction & Serializable)(id, m) -> m == null ? new ConcurrentHashMap() : m;
    }

    @Override
    public boolean isAlive() {
        ClusterHealth health = this.manager.getHealth().getClusterHealth();
        return health.getHealthStatus() != HealthStatus.DEGRADED;
    }
}

