/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.metrics;

import io.apicurio.registry.metrics.RestMetricsApply;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.RegistryType;

@Interceptor
@RestMetricsApply
public class RestMetricsInterceptor {
    @Inject
    @RegistryType(type=MetricRegistry.Type.APPLICATION)
    MetricRegistry metricRegistry;
    private Counter counter;
    private ConcurrentGauge gauge;
    private Timer timer;
    private boolean init = false;

    synchronized void init() {
        Metadata m1 = Metadata.builder().withName("rest_request_count").withDescription("Total number of REST requests. Across all endpoints.").withType(MetricType.COUNTER).build();
        Tag[] tags1 = new Tag[]{new Tag("group", "REST"), new Tag("metric", "rest_request_count")};
        this.counter = this.metricRegistry.counter(m1, tags1);
        Metadata m2 = Metadata.builder().withName("concurrent_request_count").withDescription("Number of concurrent REST requests. Across all endpoints.").withType(MetricType.CONCURRENT_GAUGE).build();
        Tag[] tags2 = new Tag[]{new Tag("group", "REST"), new Tag("metric", "concurrent_request_count")};
        this.gauge = this.metricRegistry.concurrentGauge(m2, tags2);
        Metadata m3 = Metadata.builder().withName("rest_response_time").withDescription("Time of a request-response interval. Across all endpoints.").withType(MetricType.TIMER).withUnit("milliseconds").build();
        Tag[] tags3 = new Tag[]{new Tag("group", "REST"), new Tag("metric", "rest_response_time")};
        this.timer = this.metricRegistry.timer(m3, tags3);
        this.init = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object intercept(InvocationContext context) throws Exception {
        if (!this.init) {
            this.init();
        }
        this.counter.inc();
        this.gauge.inc();
        Timer.Context time = this.timer.time();
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            time.stop();
            this.gauge.dec();
        }
    }
}

