/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.metrics.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.metrics.RestMetricsApply;
import io.apicurio.registry.rest.ArtifactsResource;
import io.apicurio.registry.rest.Headers;
import io.apicurio.registry.rest.beans.ArtifactMetaData;
import io.apicurio.registry.rest.beans.EditableMetaData;
import io.apicurio.registry.rest.beans.IfExistsType;
import io.apicurio.registry.rest.beans.Rule;
import io.apicurio.registry.rest.beans.UpdateState;
import io.apicurio.registry.rest.beans.VersionMetaData;
import io.apicurio.registry.rules.RuleApplicationType;
import io.apicurio.registry.rules.RulesService;
import io.apicurio.registry.search.client.SearchClient;
import io.apicurio.registry.search.common.Search;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactMetaDataDto;
import io.apicurio.registry.storage.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.RuleConfigurationDto;
import io.apicurio.registry.storage.StoredArtifact;
import io.apicurio.registry.types.ArtifactMediaTypes;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.util.ArtifactIdGenerator;
import io.apicurio.registry.util.ArtifactTypeUtil;
import io.apicurio.registry.util.ContentTypeUtil;
import io.apicurio.registry.util.DtoUtil;
import io.apicurio.registry.utils.ProtoUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.interceptor.Interceptors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Timed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@RestMetricsApply
@Counted(name="rest_request_count", description="Total number of REST requests.", tags={"group=REST", "metric=rest_request_count"})
@ConcurrentGauge(name="concurrent_request_count", description="Number of concurrent REST requests.", tags={"group=REST", "metric=concurrent_request_count"})
@Timed(name="rest_response_time", description="Time of a request-response interval.", tags={"group=REST", "metric=rest_response_time"}, unit="milliseconds")
@Logged
public class ArtifactsResourceImpl
implements ArtifactsResource,
Headers {
    private static final Logger log = LoggerFactory.getLogger(ArtifactsResourceImpl.class);
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    RulesService rulesService;
    @Inject
    ArtifactIdGenerator idGenerator;
    @Context
    HttpServletRequest request;
    @Inject
    @Current
    SearchClient searchClient;

    private static ArtifactType determineArtifactType(ContentHandle content, ArtifactType xArtifactType, HttpServletRequest request) {
        ArtifactType artifactType = xArtifactType;
        if (artifactType == null && (artifactType = ArtifactsResourceImpl.getArtifactTypeFromContentType(request)) == null) {
            String contentType = request.getContentType();
            artifactType = ArtifactTypeUtil.discoverType(content, contentType);
        }
        return artifactType;
    }

    private static ArtifactType getArtifactTypeFromContentType(HttpServletRequest request) {
        String[] split;
        String contentType = request.getHeader("Content-Type");
        if (contentType != null && contentType.contains("application/json") && contentType.indexOf(59) != -1 && (split = contentType.split(";")).length > 1) {
            for (String s : split) {
                if (!s.contains("artifactType=")) continue;
                String at = s.split("=")[1];
                try {
                    return ArtifactType.valueOf(at);
                }
                catch (IllegalArgumentException e) {
                    throw new BadRequestException("Unsupported artifact type: " + at);
                }
            }
        }
        if (contentType != null && contentType.contains("x-proto")) {
            return ArtifactType.PROTOBUF;
        }
        return null;
    }

    private CompletionStage<ArtifactMetaData> indexArtifact(String artifactId, ContentHandle content, ArtifactMetaData amdd) throws CompletionException {
        try {
            Search.Artifact artifact = Search.Artifact.newBuilder().setArtifactId(artifactId).setContent(content.content()).setVersion(amdd.getVersion().intValue()).setGlobalId(amdd.getGlobalId()).setName(ProtoUtil.nullAsEmpty(amdd.getName())).setDescription(ProtoUtil.nullAsEmpty(amdd.getDescription())).setCreatedBy(ProtoUtil.nullAsEmpty(amdd.getCreatedBy())).build();
            return this.searchClient.index(artifact).whenComplete((sr, t) -> {
                if (t != null) {
                    log.error("Artifact {}/{} not indexed, error: {}", new Object[]{artifactId, amdd.getVersion(), t.getMessage()});
                } else if (sr.ok()) {
                    log.info("Artifact {}/{} successfully indexed", (Object)artifactId, (Object)amdd.getVersion());
                } else {
                    log.warn("Artifact {}/{} not indexed, status: {}", new Object[]{artifactId, amdd.getVersion(), sr.status()});
                }
            }).thenApply(sr -> amdd);
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private CompletionStage<ArtifactMetaData> handleIfExists(ArtifactType xRegistryArtifactType, String xRegistryArtifactId, IfExistsType ifExists, ContentHandle content) {
        ArtifactMetaData artifactMetaData = this.getArtifactMetaData(xRegistryArtifactId);
        switch (ifExists) {
            case UPDATE: {
                return this.updateArtifactInternal(xRegistryArtifactId, xRegistryArtifactType, content);
            }
            case RETURN: {
                return CompletableFuture.completedFuture(artifactMetaData);
            }
        }
        throw new ArtifactAlreadyExistsException(xRegistryArtifactId);
    }

    @Override
    public void updateArtifactState(String artifactId, UpdateState data) {
        Objects.requireNonNull(artifactId);
        Objects.requireNonNull(data.getState());
        this.storage.updateArtifactState(artifactId, data.getState());
    }

    @Override
    public List<String> listArtifacts() {
        return new ArrayList<String>(this.storage.getArtifactIds());
    }

    @Override
    public void updateArtifactVersionState(Integer version, String artifactId, UpdateState data) {
        Objects.requireNonNull(artifactId);
        Objects.requireNonNull(data.getState());
        Objects.requireNonNull(version);
        this.storage.updateArtifactState(artifactId, data.getState(), version);
    }

    @Override
    public void testUpdateArtifact(String artifactId, ArtifactType xRegistryArtifactType, InputStream data) {
        Objects.requireNonNull(artifactId);
        ContentHandle content = ContentHandle.create(data);
        if (ContentTypeUtil.isApplicationYaml(this.request)) {
            content = ContentTypeUtil.yamlToJson(content);
        }
        ArtifactType artifactType = ArtifactsResourceImpl.determineArtifactType(content, xRegistryArtifactType, this.request);
        this.rulesService.applyRules(artifactId, artifactType, content, RuleApplicationType.UPDATE);
    }

    @Override
    public CompletionStage<ArtifactMetaData> createArtifact(ArtifactType xRegistryArtifactType, String xRegistryArtifactId, IfExistsType ifExists, InputStream data) {
        ContentHandle content;
        ContentHandle finalContent = content = ContentHandle.create(data);
        try {
            String artifactId = xRegistryArtifactId;
            if (artifactId == null || artifactId.trim().isEmpty()) {
                artifactId = this.idGenerator.generate();
            }
            if (ContentTypeUtil.isApplicationYaml(this.request)) {
                content = ContentTypeUtil.yamlToJson(content);
            }
            ArtifactType artifactType = ArtifactsResourceImpl.determineArtifactType(content, xRegistryArtifactType, this.request);
            this.rulesService.applyRules(artifactId, artifactType, content, RuleApplicationType.CREATE);
            String finalArtifactId = artifactId;
            return this.storage.createArtifact(artifactId, artifactType, content).exceptionally(t -> {
                if (t instanceof CompletionException) {
                    t = t.getCause();
                }
                if (t instanceof ArtifactAlreadyExistsException) {
                    return null;
                }
                throw new CompletionException((Throwable)t);
            }).thenCompose(amd -> amd == null ? this.handleIfExists(xRegistryArtifactType, xRegistryArtifactId, ifExists, finalContent) : CompletableFuture.completedFuture(DtoUtil.dtoToMetaData(finalArtifactId, artifactType, amd))).thenCompose(amdd -> this.indexArtifact(finalArtifactId, finalContent, (ArtifactMetaData)amdd));
        }
        catch (ArtifactAlreadyExistsException ex) {
            return this.handleIfExists(xRegistryArtifactType, xRegistryArtifactId, ifExists, content).thenCompose(amdd -> this.indexArtifact(xRegistryArtifactId, finalContent, (ArtifactMetaData)amdd));
        }
    }

    @Override
    public Response getLatestArtifact(String artifactId) {
        ArtifactMetaDataDto metaData = this.storage.getArtifactMetaData(artifactId);
        StoredArtifact artifact = this.storage.getArtifact(artifactId);
        MediaType contentType = ArtifactMediaTypes.JSON;
        if (metaData.getType() == ArtifactType.PROTOBUF) {
            contentType = ArtifactMediaTypes.PROTO;
        }
        if (metaData.getType() == ArtifactType.WSDL || metaData.getType() == ArtifactType.XSD || metaData.getType() == ArtifactType.XML) {
            contentType = ArtifactMediaTypes.XML;
        }
        Response.ResponseBuilder builder = Response.ok((Object)artifact.getContent(), (MediaType)contentType);
        this.checkIfDeprecated(metaData::getState, artifactId, metaData.getVersion(), builder);
        return builder.build();
    }

    private CompletionStage<ArtifactMetaData> updateArtifactInternal(String artifactId, ArtifactType xRegistryArtifactType, ContentHandle content) {
        Objects.requireNonNull(artifactId);
        if (ContentTypeUtil.isApplicationYaml(this.request)) {
            content = ContentTypeUtil.yamlToJson(content);
        }
        ArtifactType artifactType = ArtifactsResourceImpl.determineArtifactType(content, xRegistryArtifactType, this.request);
        this.rulesService.applyRules(artifactId, artifactType, content, RuleApplicationType.UPDATE);
        return this.storage.updateArtifact(artifactId, artifactType, content).thenApply(dto -> DtoUtil.dtoToMetaData(artifactId, artifactType, dto));
    }

    @Override
    public CompletionStage<ArtifactMetaData> updateArtifact(String artifactId, ArtifactType xRegistryArtifactType, InputStream data) {
        ContentHandle content = ContentHandle.create(data);
        return this.updateArtifactInternal(artifactId, xRegistryArtifactType, content).thenCompose(amdd -> this.indexArtifact(artifactId, content, (ArtifactMetaData)amdd));
    }

    @Override
    public void deleteArtifact(String artifactId) {
        this.storage.deleteArtifact(artifactId);
    }

    @Override
    public List<Long> listArtifactVersions(String artifactId) {
        SortedSet<Long> versions = this.storage.getArtifactVersions(artifactId);
        return new ArrayList<Long>(versions);
    }

    @Override
    public CompletionStage<VersionMetaData> createArtifactVersion(String artifactId, ArtifactType xRegistryArtifactType, InputStream data) {
        Objects.requireNonNull(artifactId);
        ContentHandle content = ContentHandle.create(data);
        if (ContentTypeUtil.isApplicationYaml(this.request)) {
            content = ContentTypeUtil.yamlToJson(content);
        }
        ArtifactType artifactType = ArtifactsResourceImpl.determineArtifactType(content, xRegistryArtifactType, this.request);
        this.rulesService.applyRules(artifactId, artifactType, content, RuleApplicationType.UPDATE);
        ContentHandle finalContent = content;
        return this.storage.updateArtifact(artifactId, artifactType, content).thenCompose(amdd -> this.indexArtifact(artifactId, finalContent, DtoUtil.dtoToMetaData(artifactId, artifactType, amdd))).thenApply(amd -> DtoUtil.dtoToVersionMetaData(artifactId, artifactType, amd));
    }

    @Override
    public Response getArtifactVersion(Integer version, String artifactId) {
        ArtifactMetaDataDto metaData = this.storage.getArtifactMetaData(artifactId);
        StoredArtifact artifact = this.storage.getArtifactVersion(artifactId, version.intValue());
        MediaType contentType = ArtifactMediaTypes.JSON;
        if (metaData.getType() == ArtifactType.PROTOBUF) {
            contentType = ArtifactMediaTypes.PROTO;
        }
        if (metaData.getType() == ArtifactType.WSDL || metaData.getType() == ArtifactType.XSD || metaData.getType() == ArtifactType.XML) {
            contentType = ArtifactMediaTypes.XML;
        }
        Response.ResponseBuilder builder = Response.ok((Object)artifact.getContent(), (MediaType)contentType);
        this.checkIfDeprecated(metaData::getState, artifactId, version, builder);
        return builder.build();
    }

    @Override
    public List<RuleType> listArtifactRules(String artifactId) {
        return this.storage.getArtifactRules(artifactId);
    }

    @Override
    public void createArtifactRule(String artifactId, Rule data) {
        RuleConfigurationDto config = new RuleConfigurationDto();
        config.setConfiguration(data.getConfig());
        this.storage.createArtifactRule(artifactId, data.getType(), config);
    }

    @Override
    public void deleteArtifactRules(String artifactId) {
        this.storage.deleteArtifactRules(artifactId);
    }

    @Override
    public Rule getArtifactRuleConfig(RuleType rule, String artifactId) {
        RuleConfigurationDto dto = this.storage.getArtifactRule(artifactId, rule);
        Rule rval = new Rule();
        rval.setConfig(dto.getConfiguration());
        rval.setType(rule);
        return rval;
    }

    @Override
    public Rule updateArtifactRuleConfig(RuleType rule, String artifactId, Rule data) {
        RuleConfigurationDto dto = new RuleConfigurationDto(data.getConfig());
        this.storage.updateArtifactRule(artifactId, rule, dto);
        Rule rval = new Rule();
        rval.setType(rule);
        rval.setConfig(data.getConfig());
        return rval;
    }

    @Override
    public void deleteArtifactRule(RuleType rule, String artifactId) {
        this.storage.deleteArtifactRule(artifactId, rule);
    }

    @Override
    public ArtifactMetaData getArtifactMetaData(String artifactId) {
        ArtifactMetaDataDto dto = this.storage.getArtifactMetaData(artifactId);
        return DtoUtil.dtoToMetaData(artifactId, dto.getType(), dto);
    }

    @Override
    public ArtifactMetaData getArtifactMetaDataByContent(String artifactId, InputStream data) {
        ContentHandle content = ContentHandle.create(data);
        if (ContentTypeUtil.isApplicationYaml(this.request)) {
            content = ContentTypeUtil.yamlToJson(content);
        }
        ArtifactMetaDataDto dto = this.storage.getArtifactMetaData(artifactId, content);
        return DtoUtil.dtoToMetaData(artifactId, dto.getType(), dto);
    }

    @Override
    public void updateArtifactMetaData(String artifactId, EditableMetaData data) {
        EditableArtifactMetaDataDto dto = new EditableArtifactMetaDataDto();
        dto.setName(data.getName());
        dto.setDescription(data.getDescription());
        dto.setLabels(data.getLabels());
        this.storage.updateArtifactMetaData(artifactId, dto);
    }

    @Override
    public VersionMetaData getArtifactVersionMetaData(Integer version, String artifactId) {
        ArtifactVersionMetaDataDto dto = this.storage.getArtifactVersionMetaData(artifactId, version.intValue());
        return DtoUtil.dtoToVersionMetaData(artifactId, dto.getType(), dto);
    }

    @Override
    public void updateArtifactVersionMetaData(Integer version, String artifactId, EditableMetaData data) {
        EditableArtifactMetaDataDto dto = new EditableArtifactMetaDataDto();
        dto.setName(data.getName());
        dto.setDescription(data.getDescription());
        this.storage.updateArtifactVersionMetaData(artifactId, version.longValue(), dto);
    }

    @Override
    public void deleteArtifactVersionMetaData(Integer version, String artifactId) {
        this.storage.deleteArtifactVersionMetaData(artifactId, version.intValue());
    }
}

