/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest;

import io.apicurio.registry.ccompat.rest.error.ConflictException;
import io.apicurio.registry.ccompat.rest.error.UnprocessableEntityException;
import io.apicurio.registry.metrics.ResponseErrorLivenessCheck;
import io.apicurio.registry.rest.beans.Error;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.storage.AlreadyExistsException;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.InvalidArtifactStateException;
import io.apicurio.registry.storage.InvalidArtifactTypeException;
import io.apicurio.registry.storage.NotFoundException;
import io.apicurio.registry.storage.RuleAlreadyExistsException;
import io.apicurio.registry.storage.RuleNotFoundException;
import io.apicurio.registry.storage.VersionNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Provider
public class RegistryExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger log = LoggerFactory.getLogger(RegistryExceptionMapper.class);
    private static final int HTTP_UNPROCESSABLE_ENTITY = 422;
    private static final Map<Class<? extends Exception>, Integer> CODE_MAP;
    @Inject
    ResponseErrorLivenessCheck liveness;
    @Context
    HttpServletRequest request;

    public static Set<Class<? extends Exception>> getIgnored() {
        return CODE_MAP.keySet();
    }

    public Response toResponse(Throwable t) {
        int code;
        Response.ResponseBuilder builder;
        if (t instanceof WebApplicationException) {
            WebApplicationException wae = (WebApplicationException)t;
            Response response = wae.getResponse();
            builder = Response.fromResponse((Response)response);
            code = response.getStatus();
        } else {
            code = CODE_MAP.getOrDefault(t.getClass(), 500);
            builder = Response.status((int)code);
        }
        if (code == 500) {
            this.liveness.suspectWithException(t);
            log.error(t.getMessage(), t);
        }
        Error error = RegistryExceptionMapper.toError(t, code);
        if (this.isCompatEndpoint()) {
            error.setDetail(null);
        }
        return builder.type("application/json").entity((Object)error).build();
    }

    private boolean isCompatEndpoint() {
        if (this.request != null) {
            return this.request.getRequestURI().contains("ccompat");
        }
        return false;
    }

    private static Error toError(Throwable t, int code) {
        Error error = new Error();
        error.setErrorCode(code);
        error.setMessage(t.getLocalizedMessage());
        error.setDetail(RegistryExceptionMapper.getStackTrace(t));
        return error;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getStackTrace(Throwable t) {
        try (StringWriter writer = new StringWriter();){
            t.printStackTrace(new PrintWriter(writer));
            String string = writer.toString();
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        HashMap<Class<InvalidArtifactTypeException>, Integer> map = new HashMap<Class<InvalidArtifactTypeException>, Integer>();
        map.put(AlreadyExistsException.class, 409);
        map.put(ArtifactAlreadyExistsException.class, 409);
        map.put(ArtifactNotFoundException.class, 404);
        map.put(BadRequestException.class, 400);
        map.put(InvalidArtifactStateException.class, 400);
        map.put(NotFoundException.class, 404);
        map.put(RuleAlreadyExistsException.class, 409);
        map.put(RuleNotFoundException.class, 404);
        map.put(RuleViolationException.class, 400);
        map.put(VersionNotFoundException.class, 404);
        map.put(ConflictException.class, 409);
        map.put(UnprocessableEntityException.class, 422);
        map.put(InvalidArtifactTypeException.class, 400);
        CODE_MAP = Collections.unmodifiableMap(map);
    }
}

