/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest;

import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.metrics.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.metrics.RestMetricsApply;
import io.apicurio.registry.rest.RulesResource;
import io.apicurio.registry.rest.beans.Rule;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.RuleConfigurationDto;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RuleType;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.interceptor.Interceptors;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Timed;

@ApplicationScoped
@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@RestMetricsApply
@Counted(name="rest_request_count", description="Total number of REST requests.", tags={"group=REST", "metric=rest_request_count"})
@ConcurrentGauge(name="concurrent_request_count", description="Number of concurrent REST requests.", tags={"group=REST", "metric=concurrent_request_count"})
@Timed(name="rest_response_time", description="Time of a request-response interval.", tags={"group=REST", "metric=rest_response_time"}, unit="milliseconds")
@Logged
public class RulesResourceImpl
implements RulesResource {
    @Inject
    @Current
    RegistryStorage storage;

    @Override
    public List<RuleType> listGlobalRules() {
        return this.storage.getGlobalRules();
    }

    @Override
    public void createGlobalRule(Rule data) {
        RuleConfigurationDto configDto = new RuleConfigurationDto();
        configDto.setConfiguration(data.getConfig());
        this.storage.createGlobalRule(data.getType(), configDto);
    }

    @Override
    public void deleteAllGlobalRules() {
        this.storage.deleteGlobalRules();
    }

    @Override
    public Rule getGlobalRuleConfig(RuleType rule) {
        RuleConfigurationDto dto = this.storage.getGlobalRule(rule);
        Rule ruleBean = new Rule();
        ruleBean.setType(rule);
        ruleBean.setConfig(dto.getConfiguration());
        return ruleBean;
    }

    @Override
    public Rule updateGlobalRuleConfig(RuleType rule, Rule data) {
        RuleConfigurationDto configDto = new RuleConfigurationDto();
        configDto.setConfiguration(data.getConfig());
        this.storage.updateGlobalRule(rule, configDto);
        Rule ruleBean = new Rule();
        ruleBean.setType(rule);
        ruleBean.setConfig(data.getConfig());
        return ruleBean;
    }

    @Override
    public void deleteGlobalRule(RuleType rule) {
        this.storage.deleteGlobalRule(rule);
    }
}

