/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest;

import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.metrics.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.metrics.RestMetricsApply;
import io.apicurio.registry.rest.Headers;
import io.apicurio.registry.rest.SearchResource;
import io.apicurio.registry.rest.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.beans.SearchOver;
import io.apicurio.registry.rest.beans.SortOrder;
import io.apicurio.registry.rest.beans.VersionSearchResults;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.types.Current;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.interceptor.Interceptors;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Timed;

@ApplicationScoped
@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@RestMetricsApply
@Counted(name="rest_request_count", description="Total number of REST requests.", tags={"group=REST", "metric=rest_request_count"})
@ConcurrentGauge(name="concurrent_request_count", description="Number of concurrent REST requests.", tags={"group=REST", "metric=concurrent_request_count"})
@Timed(name="rest_response_time", description="Time of a request-response interval.", tags={"group=REST", "metric=rest_response_time"}, unit="milliseconds")
@Logged
public class SearchResourceImpl
implements SearchResource,
Headers {
    @Inject
    @Current
    RegistryStorage registryStorage;

    @Override
    public ArtifactSearchResults searchArtifacts(String search, Integer offset, Integer limit, SearchOver searchOver, SortOrder sortOrder) {
        if (offset == null) {
            offset = 0;
        }
        if (limit == null) {
            limit = 10;
        }
        SortOrder order = sortOrder == null ? SortOrder.asc : sortOrder;
        SearchOver over = searchOver == null ? SearchOver.everything : searchOver;
        return this.registryStorage.searchArtifacts(search, offset, limit, over, order);
    }

    @Override
    public VersionSearchResults searchVersions(String artifactId, Integer offset, Integer limit) {
        if (offset == null) {
            offset = 0;
        }
        if (limit == null) {
            limit = 10;
        }
        return this.registryStorage.searchVersions(artifactId, offset, limit);
    }
}

