/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.RuleApplicationType;
import io.apicurio.registry.rules.RuleContext;
import io.apicurio.registry.rules.RuleExecutor;
import io.apicurio.registry.rules.RuleExecutorFactory;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.RulesService;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.RuleConfigurationDto;
import io.apicurio.registry.storage.StoredArtifact;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RuleType;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class RulesServiceImpl
implements RulesService {
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    RuleExecutorFactory factory;

    @Override
    public void applyRules(String artifactId, ArtifactType artifactType, ContentHandle artifactContent, RuleApplicationType ruleApplicationType) throws RuleViolationException {
        boolean useGlobalRules = false;
        List<RuleType> rules = Collections.EMPTY_LIST;
        if (ruleApplicationType == RuleApplicationType.UPDATE) {
            rules = this.storage.getArtifactRules(artifactId);
        }
        if (rules.isEmpty()) {
            rules = this.storage.getGlobalRules();
            useGlobalRules = true;
        }
        if (rules.isEmpty()) {
            return;
        }
        ContentHandle currentArtifactContent = null;
        if (ruleApplicationType == RuleApplicationType.UPDATE) {
            StoredArtifact currentArtifact = this.storage.getArtifact(artifactId);
            currentArtifactContent = currentArtifact.getContent();
        }
        for (RuleType ruleType : rules) {
            RuleConfigurationDto configurationDto = useGlobalRules ? this.storage.getGlobalRule(ruleType) : this.storage.getArtifactRule(artifactId, ruleType);
            RuleExecutor executor = this.factory.createExecutor(ruleType);
            RuleContext context = new RuleContext(artifactId, artifactType, configurationDto.getConfiguration(), currentArtifactContent, artifactContent);
            executor.execute(context);
        }
    }

    @Override
    public void applyRule(String artifactId, ArtifactType artifactType, ContentHandle artifactContent, RuleType ruleType, String ruleConfiguration, RuleApplicationType ruleApplicationType) throws RuleViolationException {
        ContentHandle currentArtifactContent = null;
        if (ruleApplicationType == RuleApplicationType.UPDATE) {
            StoredArtifact currentArtifact = this.storage.getArtifact(artifactId);
            currentArtifactContent = currentArtifact.getContent();
        }
        this.applyRule(artifactId, artifactType, currentArtifactContent, artifactContent, ruleType, ruleConfiguration);
    }

    private void applyRule(String artifactId, ArtifactType artifactType, ContentHandle currentContent, ContentHandle updatedContent, RuleType ruleType, String ruleConfiguration) {
        RuleExecutor executor = this.factory.createExecutor(ruleType);
        RuleContext context = new RuleContext(artifactId, artifactType, ruleConfiguration, currentContent, updatedContent);
        executor.execute(context);
    }

    @Override
    public void applyRule(String artifactId, long artifactVersion, ArtifactType artifactType, ContentHandle updatedContent) throws RuleViolationException {
        RuleConfigurationDto configurationDto;
        StoredArtifact versionContent = this.storage.getArtifactVersion(artifactId, artifactVersion);
        for (RuleType ruleType : this.storage.getGlobalRules()) {
            configurationDto = this.storage.getGlobalRule(ruleType);
            this.applyRule(artifactId, artifactType, versionContent.getContent(), updatedContent, ruleType, configurationDto.getConfiguration());
        }
        for (RuleType ruleType : this.storage.getArtifactRules(artifactId)) {
            configurationDto = this.storage.getArtifactRule(artifactId, ruleType);
            this.applyRule(artifactId, artifactType, versionContent.getContent(), updatedContent, ruleType, configurationDto.getConfiguration());
        }
    }
}

