/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.rules.RuleContext;
import io.apicurio.registry.rules.RuleExecutor;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.compatibility.CompatibilityChecker;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
@Logged
public class CompatibilityRuleExecutor
implements RuleExecutor {
    @Inject
    ArtifactTypeUtilProviderFactory factory;

    @Override
    public void execute(RuleContext context) throws RuleViolationException {
        List<ContentHandle> existingArtifacts;
        CompatibilityLevel level = CompatibilityLevel.valueOf(context.getConfiguration());
        ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(context.getArtifactType());
        CompatibilityChecker checker = provider.getCompatibilityChecker();
        List<ContentHandle> list = existingArtifacts = context.getCurrentContent() != null ? Collections.singletonList(context.getCurrentContent()) : Collections.emptyList();
        if (!checker.isCompatibleWith(level, existingArtifacts, context.getUpdatedContent())) {
            throw new RuleViolationException(String.format("Incompatible artifact: %s [%s]", new Object[]{context.getArtifactId(), context.getArtifactType()}), RuleType.COMPATIBILITY, context.getConfiguration());
        }
    }
}

