/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility;

import com.squareup.wire.schema.internal.parser.EnumConstantElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import io.apicurio.registry.rules.compatibility.ProtobufFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class ProtobufCompatibilityCheckerImpl {
    private final ProtobufFile fileBefore;
    private final ProtobufFile fileAfter;

    public ProtobufCompatibilityCheckerImpl(ProtobufFile fileBefore, ProtobufFile fileAfter) {
        this.fileBefore = fileBefore;
        this.fileAfter = fileAfter;
    }

    public boolean validate() {
        int totalIssues = 0;
        totalIssues += this.checkNoUsingReservedFields();
        totalIssues += this.checkNoRemovingReservedFields();
        totalIssues += this.checkNoRemovingFieldsWithoutReserve();
        totalIssues += this.checkNoChangingFieldIDs();
        totalIssues += this.checkNoChangingFieldTypes();
        totalIssues += this.checkNoChangingFieldNames();
        totalIssues += this.checkNoRemovingServiceRPCs();
        return (totalIssues += this.checkNoChangingRPCSignature()) == 0;
    }

    public int checkNoUsingReservedFields() {
        int issues = 0;
        Map<String, Set<Object>> reservedFields = this.fileBefore.getReservedFields();
        Map<String, Set<Object>> nonReservedFields = this.fileAfter.getNonReservedFields();
        for (Map.Entry<String, Set<Object>> entry : nonReservedFields.entrySet()) {
            Set<Object> old = reservedFields.get(entry.getKey());
            if (old == null) continue;
            HashSet intersection = new HashSet(entry.getValue());
            intersection.retainAll(old);
            if (intersection.isEmpty()) continue;
            issues += intersection.size();
        }
        return issues;
    }

    public int checkNoRemovingReservedFields() {
        int issues = 0;
        Map<String, Set<Object>> before = this.fileBefore.getReservedFields();
        Map<String, Set<Object>> after = this.fileAfter.getReservedFields();
        for (Map.Entry<String, Set<Object>> entry : before.entrySet()) {
            Set<Object> afterKeys = after.get(entry.getKey());
            if (afterKeys != null) {
                HashSet intersection = new HashSet(entry.getValue());
                intersection.retainAll(afterKeys);
                int diff = entry.getValue().size() - intersection.size();
                if (diff == 0) continue;
                issues += diff;
                continue;
            }
            issues += entry.getValue().size();
        }
        return issues;
    }

    public int checkNoRemovingFieldsWithoutReserve() {
        int issues = 0;
        Map<String, Map<String, FieldElement>> before = this.fileBefore.getFieldMap();
        Map<String, Map<String, FieldElement>> after = this.fileAfter.getFieldMap();
        Map<String, Set<Object>> afterReservedFields = this.fileAfter.getReservedFields();
        Map<String, Set<Object>> afterNonreservedFields = this.fileAfter.getNonReservedFields();
        for (Map.Entry<String, Map<String, FieldElement>> entry : before.entrySet()) {
            HashSet<String> removedFieldNames = new HashSet<String>(entry.getValue().keySet());
            Map<String, FieldElement> updated = after.get(entry.getKey());
            if (updated != null) {
                removedFieldNames.removeAll(updated.keySet());
            }
            Set reserved = afterReservedFields.getOrDefault(entry.getKey(), Collections.emptySet());
            Set nonreserved = afterNonreservedFields.getOrDefault(entry.getKey(), Collections.emptySet());
            HashSet<String> nonReservedRemovedFieldNames = new HashSet<String>(removedFieldNames);
            nonReservedRemovedFieldNames.removeAll(reserved);
            issues += nonReservedRemovedFieldNames.size();
            for (FieldElement fieldElement : entry.getValue().values()) {
                if (!removedFieldNames.contains(fieldElement.getName()) || reserved.contains(fieldElement.getTag()) || nonreserved.contains(fieldElement.getTag())) continue;
                ++issues;
            }
        }
        return issues;
    }

    public int checkNoChangingFieldIDs() {
        int issues = 0;
        Map<String, Map<String, FieldElement>> before = this.fileBefore.getFieldMap();
        Map<String, Map<String, FieldElement>> after = this.fileAfter.getFieldMap();
        for (Map.Entry<String, Map<String, FieldElement>> entry : before.entrySet()) {
            Map<String, FieldElement> afterMap = after.get(entry.getKey());
            if (afterMap == null) continue;
            for (Map.Entry<String, FieldElement> beforeKV : entry.getValue().entrySet()) {
                FieldElement afterFE = afterMap.get(beforeKV.getKey());
                if (afterFE == null || beforeKV.getValue().getTag() == afterFE.getTag()) continue;
                ++issues;
            }
        }
        Map<String, Map<String, EnumConstantElement>> beforeEnum = this.fileBefore.getEnumFieldMap();
        Map<String, Map<String, EnumConstantElement>> afterEnum = this.fileAfter.getEnumFieldMap();
        for (Map.Entry<String, Map<String, EnumConstantElement>> entry : beforeEnum.entrySet()) {
            Map<String, EnumConstantElement> afterMap = afterEnum.get(entry.getKey());
            if (afterMap == null) continue;
            for (Map.Entry<String, EnumConstantElement> beforeKV : entry.getValue().entrySet()) {
                EnumConstantElement afterECE = afterMap.get(beforeKV.getKey());
                if (afterECE == null || beforeKV.getValue().getTag() == afterECE.getTag()) continue;
                ++issues;
            }
        }
        return issues;
    }

    public int checkNoChangingFieldTypes() {
        int issues = 0;
        Map<String, Map<String, FieldElement>> before = this.fileBefore.getFieldMap();
        Map<String, Map<String, FieldElement>> after = this.fileAfter.getFieldMap();
        for (Map.Entry<String, Map<String, FieldElement>> entry : before.entrySet()) {
            Map<String, FieldElement> afterMap = after.get(entry.getKey());
            if (afterMap == null) continue;
            for (Map.Entry<String, FieldElement> beforeKV : entry.getValue().entrySet()) {
                FieldElement afterFE = afterMap.get(beforeKV.getKey());
                if (afterFE != null && !beforeKV.getValue().getType().equals(afterFE.getType())) {
                    ++issues;
                }
                if (afterFE == null || Objects.equals(beforeKV.getValue().getLabel(), afterFE.getLabel())) continue;
                ++issues;
            }
        }
        return issues;
    }

    public int checkNoChangingFieldNames() {
        int issues = 0;
        HashMap<String, Map<Integer, String>> before = new HashMap<String, Map<Integer, String>>(this.fileBefore.getFieldsById());
        before.putAll(this.fileBefore.getEnumFieldsById());
        HashMap<String, Map<Integer, String>> after = new HashMap<String, Map<Integer, String>>(this.fileAfter.getFieldsById());
        after.putAll(this.fileAfter.getEnumFieldsById());
        for (Map.Entry entry : before.entrySet()) {
            Map afterMap = (Map)after.get(entry.getKey());
            if (afterMap == null) continue;
            for (Map.Entry beforeKV : ((Map)entry.getValue()).entrySet()) {
                String nameAfter = (String)afterMap.get(beforeKV.getKey());
                if (((String)beforeKV.getValue()).equals(nameAfter)) continue;
                ++issues;
            }
        }
        return issues;
    }

    public int checkNoRemovingServiceRPCs() {
        int issues = 0;
        Map<String, Set<String>> before = this.fileBefore.getServiceRPCnames();
        Map<String, Set<String>> after = this.fileAfter.getServiceRPCnames();
        for (Map.Entry<String, Set<String>> entry : before.entrySet()) {
            Set<String> afterSet = after.get(entry.getKey());
            HashSet diff = new HashSet(entry.getValue());
            if (afterSet != null) {
                diff.removeAll(afterSet);
            }
            issues += diff.size();
        }
        return issues;
    }

    public int checkNoChangingRPCSignature() {
        int issues = 0;
        Map<String, Map<String, String>> before = this.fileBefore.getServiceRPCSignatures();
        Map<String, Map<String, String>> after = this.fileAfter.getServiceRPCSignatures();
        for (Map.Entry<String, Map<String, String>> entry : before.entrySet()) {
            Map<String, String> afterMap = after.get(entry.getKey());
            if (afterMap == null) continue;
            for (Map.Entry<String, String> beforeKV : entry.getValue().entrySet()) {
                String afterSig = afterMap.get(beforeKV.getKey());
                if (beforeKV.getValue().equals(afterSig)) continue;
                ++issues;
            }
        }
        return issues;
    }
}

