/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility.jsonschema.diff;

import io.apicurio.registry.rules.compatibility.jsonschema.JsonSchemaWrapperVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffContext;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffType;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffUtil;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.SchemaDiffVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.ArraySchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.SchemaWrapper;
import java.util.List;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.Schema;

public class ArraySchemaDiffVisitor
extends JsonSchemaWrapperVisitor {
    private final DiffContext ctx;
    private final ArraySchema original;

    public ArraySchemaDiffVisitor(DiffContext ctx, ArraySchema original) {
        this.ctx = ctx;
        this.original = original;
    }

    @Override
    public void visitArraySchema(ArraySchemaWrapper arraySchema) {
        this.ctx.log("Visiting " + arraySchema + " at " + arraySchema.getWrapped().getLocation());
        super.visitArraySchema(arraySchema);
    }

    @Override
    public void visitMinItems(Integer minItems) {
        DiffUtil.diffInteger(this.ctx.sub("minItems"), this.original.getMinItems(), minItems, DiffType.ARRAY_TYPE_MIN_ITEMS_ADDED, DiffType.ARRAY_TYPE_MIN_ITEMS_REMOVED, DiffType.ARRAY_TYPE_MIN_ITEMS_INCREASED, DiffType.ARRAY_TYPE_MIN_ITEMS_DECREASED);
        super.visitMinItems(minItems);
    }

    @Override
    public void visitMaxItems(Integer maxItems) {
        DiffUtil.diffInteger(this.ctx.sub("maxItems"), this.original.getMaxItems(), maxItems, DiffType.ARRAY_TYPE_MAX_ITEMS_ADDED, DiffType.ARRAY_TYPE_MAX_ITEMS_REMOVED, DiffType.ARRAY_TYPE_MAX_ITEMS_INCREASED, DiffType.ARRAY_TYPE_MAX_ITEMS_DECREASED);
        super.visitMaxItems(maxItems);
    }

    @Override
    public void visitUniqueItems(boolean uniqueItems) {
        DiffUtil.diffBooleanTransition(this.ctx.sub("uniqueItems"), this.original.needsUniqueItems(), uniqueItems, false, DiffType.ARRAY_TYPE_UNIQUE_ITEMS_FALSE_TO_TRUE, DiffType.ARRAY_TYPE_UNIQUE_ITEMS_TRUE_TO_FALSE, DiffType.ARRAY_TYPE_UNIQUE_ITEMS_BOOLEAN_UNCHANGED);
        super.visitUniqueItems(uniqueItems);
    }

    @Override
    public void visitAllItemSchema(SchemaWrapper allItemSchema) {
        this.ctx.log("visitAllItemSchema: " + allItemSchema + " orig.: " + this.original.getAllItemSchema());
        DiffContext subCtx = this.ctx.sub("allItemSchema");
        if (DiffUtil.diffSubschemaAddedRemoved(subCtx, this.original.getAllItemSchema(), allItemSchema, DiffType.ARRAY_TYPE_ALL_ITEM_SCHEMA_ADDED, DiffType.ARRAY_TYPE_ALL_ITEM_SCHEMA_REMOVED)) {
            allItemSchema.accept(new SchemaDiffVisitor(subCtx, this.original.getAllItemSchema()));
        }
        super.visitAllItemSchema(allItemSchema);
    }

    @Override
    public void visitAdditionalItems(boolean additionalItems) {
        this.ctx.log("visitAdditionalItems: " + additionalItems);
        DiffUtil.diffBooleanTransition(this.ctx.sub("additionalItems"), this.original.permitsAdditionalItems(), additionalItems, true, DiffType.ARRAY_TYPE_ADDITIONAL_ITEMS_FALSE_TO_TRUE, DiffType.ARRAY_TYPE_ADDITIONAL_ITEMS_TRUE_TO_FALSE, DiffType.ARRAY_TYPE_ADDITIONAL_ITEMS_BOOLEAN_UNCHANGED);
        super.visitAdditionalItems(additionalItems);
    }

    @Override
    public void visitItemSchemas(List<SchemaWrapper> itemSchemas) {
        this.ctx.log("visitItemSchemas: " + itemSchemas);
        DiffUtil.diffInteger(this.ctx.sub("items"), this.original.getItemSchemas().size(), itemSchemas.size(), DiffType.UNDEFINED_UNUSED, DiffType.UNDEFINED_UNUSED, DiffType.ARRAY_TYPE_ITEMS_SCHEMAS_LENGTH_INCREASED, DiffType.ARRAY_TYPE_ITEMS_SCHEMAS_LENGTH_DECREASED);
        super.visitItemSchemas(itemSchemas);
    }

    @Override
    public void visitItemSchema(int index, SchemaWrapper itemSchema) {
        this.ctx.log("visitItemSchema: " + itemSchema);
        DiffContext subCtx = this.ctx.sub("items/" + index);
        if (DiffUtil.diffSubschemaAddedRemoved(subCtx, DiffUtil.getExceptionally(subCtx, () -> (Schema)this.original.getItemSchemas().get(index)), itemSchema, DiffType.ARRAY_TYPE_ITEMS_SCHEMA_ADDED, DiffType.ARRAY_TYPE_ITEMS_SCHEMA_REMOVED)) {
            itemSchema.accept(new SchemaDiffVisitor(subCtx, (Schema)this.original.getItemSchemas().get(index)));
        }
        super.visitItemSchema(index, itemSchema);
    }

    @Override
    public void visitSchemaOfAdditionalItems(SchemaWrapper schemaOfAdditionalItems) {
        this.ctx.log("visitSchemaOfAdditionalItems: " + schemaOfAdditionalItems);
        DiffContext subCtx = this.ctx.sub("schemaOfAdditionalItems");
        if (DiffUtil.diffSubschemaAddedRemoved(subCtx, this.original.getSchemaOfAdditionalItems(), schemaOfAdditionalItems, DiffType.ARRAY_TYPE_SCHEMA_OF_ADDITIONAL_ITEMS_ADDED, DiffType.ARRAY_TYPE_SCHEMA_OF_ADDITIONAL_ITEMS_REMOVED)) {
            schemaOfAdditionalItems.accept(new SchemaDiffVisitor(subCtx, this.original.getSchemaOfAdditionalItems()));
        }
        super.visitSchemaOfAdditionalItems(schemaOfAdditionalItems);
    }

    @Override
    public void visitContainedItemSchema(SchemaWrapper containedItemSchema) {
        this.ctx.log("visitContainedItemSchema: " + containedItemSchema);
        DiffContext subCtx = this.ctx.sub("containedItemSchema");
        if (DiffUtil.diffSubschemaAddedRemoved(subCtx, this.original.getContainedItemSchema(), containedItemSchema, DiffType.ARRAY_TYPE_CONTAINED_ITEMS_SCHEMA_ADDED, DiffType.ARRAY_TYPE_CONTAINED_ITEMS_SCHEMA_REMOVED)) {
            containedItemSchema.accept(new SchemaDiffVisitor(subCtx, this.original.getContainedItemSchema()));
        }
        super.visitContainedItemSchema(containedItemSchema);
    }
}

