/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility.jsonschema.diff;

import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffContext;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffType;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.SchemaDiffVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.WrapUtil;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.everit.json.schema.Schema;

public class DiffUtil {
    public static boolean diffAddedRemoved(DiffContext ctx, Object original, Object updated, DiffType addedType, DiffType removedType) {
        if (original == null && updated != null) {
            ctx.addDifference(addedType, original, updated);
        } else if (original != null && updated == null) {
            ctx.addDifference(removedType, original, updated);
        } else {
            return original != null;
        }
        return false;
    }

    public static <T> void diffSetChanged(DiffContext ctx, Set<T> original, Set<T> updated, DiffType addedType, DiffType removedType, DiffType changedType, DiffType addedMemberType, DiffType removedMemberType) {
        if (DiffUtil.diffAddedRemoved(ctx, original, updated, addedType, removedType)) {
            boolean changed = false;
            HashSet<T> copyUpdated = new HashSet<T>(updated);
            for (T originalMember : original) {
                if (updated.contains(originalMember)) {
                    copyUpdated.remove(originalMember);
                    continue;
                }
                ctx.addDifference(removedMemberType, originalMember, null);
                changed = true;
            }
            for (Object updatedMemberRemaining : copyUpdated) {
                ctx.addDifference(addedMemberType, null, updatedMemberRemaining);
                changed = true;
            }
            if (changed) {
                ctx.addDifference(changedType, original, updated);
            }
        }
    }

    public static boolean diffSubschemaAddedRemoved(DiffContext ctx, Object original, Object updated, DiffType addedType, DiffType removedType) {
        return DiffUtil.diffAddedRemoved(ctx, original, updated, addedType, removedType);
    }

    public static boolean diffInteger(DiffContext ctx, Integer original, Integer updated, DiffType addedType, DiffType removedType, DiffType increasedType, DiffType decreasedType) {
        if (DiffUtil.diffAddedRemoved(ctx, original, updated, addedType, removedType)) {
            if (original < updated) {
                ctx.addDifference(increasedType, original, updated);
            } else if (original > updated) {
                ctx.addDifference(decreasedType, original, updated);
            } else {
                return true;
            }
        }
        return false;
    }

    public static boolean diffNumber(DiffContext ctx, Number original, Number updated, DiffType addedType, DiffType removedType, DiffType increasedType, DiffType decreasedType) {
        if (DiffUtil.diffAddedRemoved(ctx, original, updated, addedType, removedType)) {
            BigDecimal u;
            BigDecimal o = new BigDecimal(original.toString());
            if (o.compareTo(u = new BigDecimal(updated.toString())) < 0) {
                ctx.addDifference(increasedType, original, updated);
            } else if (o.compareTo(u) > 0) {
                ctx.addDifference(decreasedType, original, updated);
            } else {
                return true;
            }
        }
        return false;
    }

    public static void diffNumberOriginalMultipleOfUpdated(DiffContext ctx, Number original, Number updated, DiffType multipleOfType, DiffType notMultipleOfType) {
        Objects.requireNonNull(original);
        Objects.requireNonNull(updated);
        BigDecimal o = new BigDecimal(original.toString());
        BigDecimal u = new BigDecimal(updated.toString());
        if (o.remainder(u).equals(BigDecimal.ZERO)) {
            ctx.addDifference(multipleOfType, original, updated);
        } else {
            ctx.addDifference(notMultipleOfType, original, updated);
        }
    }

    public static void diffBooleanTransition(DiffContext ctx, Boolean original, Boolean updated, Boolean defaultValue, DiffType changeFalseToTrue, DiffType changeTrueToFalse, DiffType unchanged) {
        if (original == null) {
            original = defaultValue;
        }
        if (updated == null) {
            updated = defaultValue;
        }
        if (original.booleanValue() && !updated.booleanValue()) {
            ctx.addDifference(changeTrueToFalse, original, updated);
        } else if (!original.booleanValue() && updated.booleanValue()) {
            ctx.addDifference(changeFalseToTrue, original, updated);
        } else {
            ctx.addDifference(unchanged, original, updated);
        }
    }

    public static void diffObject(DiffContext ctx, Object original, Object updated, DiffType addedType, DiffType removedType, DiffType changedType) {
        if (DiffUtil.diffAddedRemoved(ctx, original, updated, addedType, removedType) && !original.equals(updated)) {
            ctx.addDifference(changedType, original, updated);
        }
    }

    public static void diffObjectDefault(DiffContext ctx, Object original, Object updated, Object defaultValue, DiffType addedType, DiffType removedType, DiffType changedType) {
        if (Objects.equals(defaultValue, original)) {
            original = null;
        }
        if (Objects.equals(defaultValue, updated)) {
            updated = null;
        }
        if (DiffUtil.diffAddedRemoved(ctx, original, updated, addedType, removedType) && !original.equals(updated)) {
            ctx.addDifference(changedType, original, updated);
        }
    }

    public static boolean diffObjectIdentity(DiffContext ctx, Object original, Object updated, DiffType addedType, DiffType removedType, DiffType changedType) {
        if (DiffUtil.diffAddedRemoved(ctx, original, updated, addedType, removedType) && original != updated) {
            ctx.addDifference(changedType, original, updated);
            return false;
        }
        return true;
    }

    public static void compareSchema(DiffContext ctx, Schema original, Schema updated, DiffType addedType, DiffType removedType, DiffType bothType, DiffType backwardNotForwardType, DiffType forwardNotBackwardType, DiffType none) {
        if (DiffUtil.diffAddedRemoved(ctx, original, updated, addedType, removedType)) {
            DiffContext rootCtx = DiffContext.createRootContext();
            new SchemaDiffVisitor(rootCtx, original).visit(WrapUtil.wrap(updated));
            boolean backward = rootCtx.foundAllDifferencesAreCompatible();
            rootCtx = DiffContext.createRootContext();
            new SchemaDiffVisitor(rootCtx, updated).visit(WrapUtil.wrap(original));
            boolean forward = rootCtx.foundAllDifferencesAreCompatible();
            if (backward && forward) {
                ctx.addDifference(bothType, original, updated);
            }
            if (backward && !forward) {
                ctx.addDifference(backwardNotForwardType, original, updated);
            }
            if (!backward && forward) {
                ctx.addDifference(forwardNotBackwardType, original, updated);
            }
            if (!backward && !forward) {
                ctx.addDifference(none, original, updated);
            }
        }
    }

    public static <T> T getExceptionally(DiffContext ctx, Supplier<T> getter) {
        try {
            return getter.get();
        }
        catch (Exception ex) {
            ctx.log("Caught exception when getting exceptionally: " + ex + ". Returning null.");
            return null;
        }
    }
}

