/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.validity;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.ValidationProblem;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.validity.ContentValidator;
import io.apicurio.registry.rules.validity.InvalidContentException;
import io.apicurio.registry.rules.validity.ValidityLevel;
import java.util.List;

public abstract class ApicurioDataModelContentValidator
implements ContentValidator {
    @Override
    public void validate(ValidityLevel level, ContentHandle artifactContent) throws InvalidContentException {
        List<ValidationProblem> problems;
        Document document = null;
        if (level == ValidityLevel.SYNTAX_ONLY || level == ValidityLevel.FULL) {
            try {
                document = Library.readDocumentFromJSONString(artifactContent.content());
            }
            catch (Exception e) {
                throw new InvalidContentException("Syntax violation for " + this.getDataModelType() + " artifact.", e);
            }
        }
        if (level == ValidityLevel.FULL && !(problems = Library.validate(document, null)).isEmpty()) {
            throw new InvalidContentException("The " + this.getDataModelType() + " artifact is not semantically valid. " + problems.size() + " problems found.");
        }
    }

    protected abstract String getDataModelType();
}

