/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.validity;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.validity.InvalidContentException;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.rules.validity.XmlContentValidator;
import io.apicurio.registry.util.SchemaFactoryAccessor;
import java.io.InputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.xml.transform.stream.StreamSource;

@ApplicationScoped
public class XsdContentValidator
extends XmlContentValidator {
    @Override
    public void validate(ValidityLevel level, ContentHandle artifactContent) throws InvalidContentException {
        super.validate(level, artifactContent);
        if (level == ValidityLevel.FULL) {
            try (InputStream semanticStream = artifactContent.stream();){
                StreamSource source = new StreamSource(semanticStream);
                SchemaFactoryAccessor.getSchemaFactory().newSchema(source);
            }
            catch (Exception e) {
                throw new InvalidContentException("Syntax violation for XSD Schema artifact.", e);
            }
        }
    }
}

