/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.search.client.common;

import io.apicurio.registry.search.client.SearchClient;
import io.apicurio.registry.search.client.SearchUtil;
import io.apicurio.registry.search.common.Search;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;

public abstract class InfinispanSearchClient
implements SearchClient {
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    protected static final String PROTO_CACHE = "___protobuf_metadata";
    public static final String SEARCH_CACHE_DEFAULT = "___search_cache";
    protected static final String COMMON_PROTO_KEY = "common.proto";
    protected static final String SEARCH_PROTO_KEY = "search.proto";
    protected static final String TYPE = "_type";
    protected static final String JSON_CACHE_CONFIG = "{\"distributed-cache\":{\"mode\":\"ASYNC\",\"indexing\":{\"auto-config\":true,\"index\":\"LOCAL\"}}}";
    protected static final String XML_CACHE_CONFIG = "<infinispan>\n    <cache-container>\n        <distributed-cache name=\"%s\" mode=\"ASYNC\">\n            <indexing index=\"LOCAL\" auto-config=\"true\">\n            </indexing>\n        </distributed-cache>\n    </cache-container>\n</infinispan>";
    protected final String cacheName;

    protected InfinispanSearchClient(Properties properties) {
        this(properties, SearchUtil.property(properties, "search.host", "localhost"), Integer.parseInt(SearchUtil.property(properties, "search.port", "-1")), SearchUtil.property(properties, "search.user", "user"), SearchUtil.property(properties, "search.password", "pass"), SearchUtil.property(properties, "search.cache-name", SEARCH_CACHE_DEFAULT));
    }

    protected InfinispanSearchClient(Properties properties, String host, int port, String username, String password, String cacheName) {
        this.cacheName = Objects.requireNonNull(cacheName);
        port = port >= 0 ? port : this.defaultPort();
        this.initialize(properties, host, port, username, password, cacheName);
    }

    protected abstract int defaultPort();

    protected abstract void initialize(Properties var1, String var2, int var3, String var4, String var5, String var6);

    protected String toKey(Search.Artifact artifact) {
        return String.format("%s-%s", artifact.getArtifactId(), artifact.getVersion());
    }

    public static String toFqn() {
        return Search.Artifact.class.getName().replace("Search$", "");
    }
}

