/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.search.client.kafka;

import io.apicurio.registry.search.client.SearchClient;
import io.apicurio.registry.search.client.SearchResponse;
import io.apicurio.registry.search.client.SearchResults;
import io.apicurio.registry.search.client.SearchUtil;
import io.apicurio.registry.search.client.kafka.KafkaSearchResponse;
import io.apicurio.registry.search.common.Search;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.kafka.AsyncProducer;
import io.apicurio.registry.utils.kafka.ProducerActions;
import io.apicurio.registry.utils.kafka.ProtoSerde;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaSearchClient
implements SearchClient {
    private final String topic;
    private final ProducerActions<String, Search.Artifact> producer;

    public KafkaSearchClient(Properties properties) {
        this.topic = SearchUtil.property(properties, "search.topic", "search-topic");
        String servers = SearchUtil.property(properties, "search.bootstrap-servers", "localhost:9092");
        properties.put("bootstrap.servers", servers);
        this.producer = new AsyncProducer(properties, Serdes.String().serializer(), (Serializer)ProtoSerde.parsedWith(Search.Artifact.parser()));
    }

    @Override
    public CompletionStage<Boolean> initialize(boolean reset) {
        return CompletableFuture.completedFuture(Boolean.TRUE);
    }

    @Override
    public CompletionStage<SearchResponse> index(Search.Artifact artifact) {
        ProducerRecord record = new ProducerRecord(this.topic, (Object)artifact.getArtifactId(), (Object)artifact);
        return ((CompletableFuture)this.producer.apply((Object)record)).thenApply(KafkaSearchResponse::new);
    }

    @Override
    public CompletionStage<SearchResults> search(String query) {
        throw new UnsupportedOperationException("Query is not supported!");
    }

    @Override
    public void close() {
        IoUtil.closeIgnore(this.producer);
    }
}

