/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.search.client.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.protobuf.Message;
import io.apicurio.registry.search.client.SearchResponse;
import io.apicurio.registry.search.client.SearchResults;
import io.apicurio.registry.search.client.common.InfinispanSearchClient;
import io.apicurio.registry.search.client.rest.RestSearchResponse;
import io.apicurio.registry.search.client.rest.RestSearchResults;
import io.apicurio.registry.search.common.Search;
import io.apicurio.registry.utils.IoBufferedInputStream;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.ProtoUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.logging.Level;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.client.rest.impl.okhttp.StringRestEntityOkHttp;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.dataconversion.MediaType;

public class RestSearchClient
extends InfinispanSearchClient {
    private static final BiFunction<RestResponse, RestResponse, RestResponse> RFN = (r1, r2) -> r2;
    protected final ObjectMapper mapper = new ObjectMapper();
    private RestClient client;

    public RestSearchClient(Properties properties) {
        super(properties);
    }

    @Override
    protected int defaultPort() {
        return 11222;
    }

    @Override
    protected void initialize(Properties properties, String host, int port, String username, String password, String cacheName) {
        RestClientConfiguration configuration = new RestClientConfigurationBuilder().addServer().host(host).port(port).security().authentication().username(username).password(password).build();
        this.client = RestClient.forConfiguration((RestClientConfiguration)configuration);
    }

    private RestCacheClient getCache() {
        return this.client.cache(this.cacheName);
    }

    private boolean cacheExists(String caches, String cache) {
        return caches.contains("\"" + cache + "\"");
    }

    private void reset(boolean exists, String cache, String key) throws Exception {
        if (exists) {
            CompletionStage reset = key != null ? this.client.cache(cache).remove(key).thenCompose(r -> this.client.cache(cache).remove(key + ".errors")) : this.client.cache(cache).clear();
            reset.toCompletableFuture().get();
        }
    }

    private CompletionStage<RestResponse> registerProto(String protoKey) {
        String protoContent = IoUtil.toString(this.getClass().getResourceAsStream("/" + protoKey));
        this.log.info(String.format("Using proto schema: %s%n%s", protoKey, protoContent));
        return this.client.cache("___protobuf_metadata").post(protoKey, protoContent).whenComplete((r, t) -> {
            if (t == null) {
                this.client.cache("___protobuf_metadata").get(protoKey + ".errors").thenApply(resp -> {
                    this.log.info("Proto errors: " + resp.getBody());
                    return resp;
                });
            }
        });
    }

    protected String toJson(Search.Artifact artifact) throws Exception {
        ObjectNode node = this.mapper.createObjectNode();
        node.put("_type", RestSearchClient.toFqn());
        String root = ProtoUtil.toJson((Message)artifact);
        node.setAll((ObjectNode)this.mapper.readTree(root));
        return node.toString();
    }

    @Override
    public CompletionStage<Boolean> initialize(boolean reset) throws Exception {
        CompletionStage caches = this.client.caches();
        RestResponse result = (RestResponse)caches.toCompletableFuture().get();
        String body = result.getBody();
        if (result.getStatus() != 200) {
            this.log.log(Level.SEVERE, body);
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
        boolean hasProto = this.cacheExists(body, "___protobuf_metadata");
        boolean hasSearch = this.cacheExists(body, this.cacheName);
        if (reset) {
            this.reset(hasProto, "___protobuf_metadata", "search.proto");
            this.reset(hasProto, "___protobuf_metadata", "common.proto");
            this.reset(hasSearch, this.cacheName, null);
        }
        CompletionStage<RestResponse> cs = null;
        if (reset || !hasProto) {
            cs = this.registerProto("common.proto").thenCompose(r -> this.registerProto("search.proto"));
        }
        if (reset || !hasSearch) {
            StringRestEntityOkHttp configEntity = new StringRestEntityOkHttp(MediaType.APPLICATION_JSON, "{\"distributed-cache\":{\"mode\":\"ASYNC\",\"indexing\":{\"auto-config\":true,\"index\":\"LOCAL\"}}}");
            CompletionStage<RestResponse> searchCs = this.getCache().createWithConfiguration((RestEntity)configEntity, new CacheContainerAdmin.AdminFlag[0]);
            cs = cs != null ? cs.thenCombine(searchCs, RFN) : searchCs;
        }
        return cs != null ? cs.handle((r, t) -> t == null) : CompletableFuture.completedFuture(Boolean.TRUE);
    }

    @Override
    public CompletionStage<SearchResponse> index(Search.Artifact artifact) throws Exception {
        String json = this.toJson(artifact);
        RestEntity entity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)json);
        String key = this.toKey(artifact);
        return this.getCache().post(key, entity).thenApply(r -> new RestSearchResponse(r.getStatus()));
    }

    @Override
    public CompletionStage<SearchResults> search(String query) {
        query = query.replace("$Artifact", RestSearchClient.toFqn());
        CompletionStage results = this.getCache().query(query);
        return results.thenApply(r -> {
            try {
                int status = r.getStatus();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IoBufferedInputStream rbis = new IoBufferedInputStream(r.getBodyAsStream(), (bytes, count) -> baos.write((byte[])bytes, 0, (int)count));
                JsonNode tree = this.mapper.readTree((InputStream)rbis);
                int totalResults = tree.get("total_results").asInt();
                ArrayNode hits = (ArrayNode)tree.get("hits");
                ArrayList<Search.Artifact> artifacts = new ArrayList<Search.Artifact>();
                for (int i = 0; i < hits.size(); ++i) {
                    JsonNode jsonNode = hits.get(i);
                    Search.Artifact.Builder builder = Search.Artifact.newBuilder();
                    String json = jsonNode.get("hit").toString();
                    Search.Artifact artifact = (Search.Artifact)ProtoUtil.fromJson((Message.Builder)builder, json, true);
                    artifacts.add(artifact);
                }
                return new RestSearchResults(status, totalResults, artifacts);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    @Override
    public void close() {
        IoUtil.closeIgnore((AutoCloseable)this.client);
    }
}

