/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage;

import io.apicurio.registry.storage.InvalidArtifactStateException;
import io.apicurio.registry.storage.MetaDataKeys;
import io.apicurio.registry.types.ArtifactState;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactStateExt {
    private static final Logger log = LoggerFactory.getLogger(ArtifactStateExt.class);
    private static final Map<ArtifactState, EnumSet<ArtifactState>> transitions = new HashMap<ArtifactState, EnumSet<ArtifactState>>();
    public static final EnumSet<ArtifactState> ACTIVE_STATES;

    public static boolean canTransition(ArtifactState before, ArtifactState after) {
        EnumSet<ArtifactState> states = transitions.get((Object)before);
        return states.contains((Object)after);
    }

    private static String getStateRaw(Map<String, String> context) {
        return context.get(MetaDataKeys.STATE);
    }

    public static ArtifactState getState(Map<String, String> context) {
        return ArtifactState.valueOf(ArtifactStateExt.getStateRaw(context));
    }

    public static void validateState(EnumSet<ArtifactState> states, ArtifactState state, String identifier, Number version) {
        if (states != null && !states.contains((Object)state)) {
            throw new InvalidArtifactStateException(identifier, version, state);
        }
        ArtifactStateExt.logIfDeprecated(identifier, state, version);
    }

    public static void logIfDeprecated(Object identifier, ArtifactState state, Object version) {
        if (state == ArtifactState.DEPRECATED) {
            log.warn("Artifact {} [{}] is deprecated", identifier, version);
        }
    }

    public static void applyState(Map<String, String> context, ArtifactState newState) {
        String previous = ArtifactStateExt.getStateRaw(context);
        ArtifactState previousState = previous != null ? ArtifactState.valueOf(previous) : null;
        ArtifactStateExt.applyState((ArtifactState s) -> context.put(MetaDataKeys.STATE, s.name()), previousState, newState);
    }

    public static void applyState(Consumer<ArtifactState> consumer, Map<String, String> context, ArtifactState newState) {
        String previous = ArtifactStateExt.getStateRaw(context);
        ArtifactState previousState = previous != null ? ArtifactState.valueOf(previous) : null;
        ArtifactStateExt.applyState(consumer, previousState, newState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void applyState(Consumer<ArtifactState> consumer, ArtifactState previousState, ArtifactState newState) {
        if (previousState != null) {
            if (!ArtifactStateExt.canTransition(previousState, newState)) throw new InvalidArtifactStateException(previousState, newState);
            consumer.accept(newState);
            return;
        } else {
            consumer.accept(newState);
        }
    }

    static {
        transitions.put(ArtifactState.ENABLED, EnumSet.of(ArtifactState.DISABLED, ArtifactState.DEPRECATED, ArtifactState.DELETED));
        transitions.put(ArtifactState.DISABLED, EnumSet.of(ArtifactState.ENABLED, ArtifactState.DEPRECATED, ArtifactState.DELETED));
        transitions.put(ArtifactState.DEPRECATED, EnumSet.of(ArtifactState.DELETED));
        transitions.put(ArtifactState.DELETED, EnumSet.noneOf(ArtifactState.class));
        ACTIVE_STATES = EnumSet.of(ArtifactState.ENABLED, ArtifactState.DEPRECATED);
    }
}

