/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rest.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.beans.SearchOver;
import io.apicurio.registry.rest.beans.SortOrder;
import io.apicurio.registry.rest.beans.VersionSearchResults;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactMetaDataDto;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.RegistryStorageException;
import io.apicurio.registry.storage.RuleAlreadyExistsException;
import io.apicurio.registry.storage.RuleConfigurationDto;
import io.apicurio.registry.storage.RuleNotFoundException;
import io.apicurio.registry.storage.StoredArtifact;
import io.apicurio.registry.storage.VersionNotFoundException;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.ConcurrentUtil;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.CompletionStage;

public interface RegistryStorage {
    default public boolean isReady() {
        return this.getGlobalRules() != null;
    }

    default public boolean isAlive() {
        return true;
    }

    public void updateArtifactState(String var1, ArtifactState var2);

    public void updateArtifactState(String var1, ArtifactState var2, Integer var3);

    public CompletionStage<ArtifactMetaDataDto> createArtifact(String var1, ArtifactType var2, ContentHandle var3) throws ArtifactAlreadyExistsException, RegistryStorageException;

    public SortedSet<Long> deleteArtifact(String var1) throws ArtifactNotFoundException, RegistryStorageException;

    public StoredArtifact getArtifact(String var1) throws ArtifactNotFoundException, RegistryStorageException;

    public CompletionStage<ArtifactMetaDataDto> updateArtifact(String var1, ArtifactType var2, ContentHandle var3) throws ArtifactNotFoundException, RegistryStorageException;

    public Set<String> getArtifactIds();

    public ArtifactSearchResults searchArtifacts(String var1, int var2, int var3, SearchOver var4, SortOrder var5);

    public ArtifactMetaDataDto getArtifactMetaData(String var1) throws ArtifactNotFoundException, RegistryStorageException;

    public ArtifactMetaDataDto getArtifactMetaData(String var1, ContentHandle var2) throws ArtifactNotFoundException, RegistryStorageException;

    public ArtifactMetaDataDto getArtifactMetaData(long var1) throws ArtifactNotFoundException, RegistryStorageException;

    public void updateArtifactMetaData(String var1, EditableArtifactMetaDataDto var2) throws ArtifactNotFoundException, RegistryStorageException;

    public List<RuleType> getArtifactRules(String var1) throws ArtifactNotFoundException, RegistryStorageException;

    default public void createArtifactRule(String artifactId, RuleType rule, RuleConfigurationDto config) throws ArtifactNotFoundException, RuleAlreadyExistsException, RegistryStorageException {
        ConcurrentUtil.result(this.createArtifactRuleAsync(artifactId, rule, config));
    }

    public CompletionStage<Void> createArtifactRuleAsync(String var1, RuleType var2, RuleConfigurationDto var3) throws ArtifactNotFoundException, RuleAlreadyExistsException, RegistryStorageException;

    public void deleteArtifactRules(String var1) throws ArtifactNotFoundException, RegistryStorageException;

    public RuleConfigurationDto getArtifactRule(String var1, RuleType var2) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException;

    public void updateArtifactRule(String var1, RuleType var2, RuleConfigurationDto var3) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException;

    public void deleteArtifactRule(String var1, RuleType var2) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException;

    public SortedSet<Long> getArtifactVersions(String var1) throws ArtifactNotFoundException, RegistryStorageException;

    public VersionSearchResults searchVersions(String var1, int var2, int var3);

    public StoredArtifact getArtifactVersion(long var1) throws ArtifactNotFoundException, RegistryStorageException;

    public StoredArtifact getArtifactVersion(String var1, long var2) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException;

    public void deleteArtifactVersion(String var1, long var2) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException;

    public ArtifactVersionMetaDataDto getArtifactVersionMetaData(String var1, long var2) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException;

    public void updateArtifactVersionMetaData(String var1, long var2, EditableArtifactMetaDataDto var4) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException;

    public void deleteArtifactVersionMetaData(String var1, long var2) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException;

    public List<RuleType> getGlobalRules() throws RegistryStorageException;

    public void createGlobalRule(RuleType var1, RuleConfigurationDto var2) throws RuleAlreadyExistsException, RegistryStorageException;

    public void deleteGlobalRules() throws RegistryStorageException;

    public RuleConfigurationDto getGlobalRule(RuleType var1) throws RuleNotFoundException, RegistryStorageException;

    public void updateGlobalRule(RuleType var1, RuleConfigurationDto var2) throws RuleNotFoundException, RegistryStorageException;

    public void deleteGlobalRule(RuleType var1) throws RuleNotFoundException, RegistryStorageException;
}

