/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.types.provider;

import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

@ApplicationScoped
@Logged
public class ArtifactTypeUtilProviderImpl
implements ArtifactTypeUtilProviderFactory {
    private Map<ArtifactType, ArtifactTypeUtilProvider> map = new ConcurrentHashMap<ArtifactType, ArtifactTypeUtilProvider>();
    @Inject
    Instance<ArtifactTypeUtilProvider> providers;

    @Override
    public ArtifactTypeUtilProvider getArtifactTypeProvider(ArtifactType type) {
        return this.map.computeIfAbsent(type, t -> this.providers.stream().filter(a -> a.getArtifactType() == t).findFirst().orElseThrow(() -> new IllegalStateException("No such artifact type provider: " + (Object)t)));
    }
}

