/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.apicurio.registry.content.ContentHandle;
import javax.servlet.http.HttpServletRequest;

public final class ContentTypeUtil {
    public static final String CT_APPLICATION_JSON = "application/json";
    public static final String CT_APPLICATION_YAML = "application/x-yaml";
    public static final String CT_APPLICATION_XML = "application/xml";
    private static final ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final ObjectMapper jsonMapper = new ObjectMapper();

    public static final boolean isApplicationJson(HttpServletRequest request) {
        String ct = request.getContentType();
        if (ct == null) {
            return false;
        }
        return ct.contains(CT_APPLICATION_JSON);
    }

    public static final boolean isApplicationYaml(HttpServletRequest request) {
        String ct = request.getContentType();
        if (ct == null) {
            return false;
        }
        return ct.contains(CT_APPLICATION_YAML);
    }

    public static final ContentHandle yamlToJson(ContentHandle yaml) {
        try {
            JsonNode root = yamlMapper.readTree(yaml.stream());
            return ContentHandle.create(jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)root));
        }
        catch (Throwable t) {
            return yaml;
        }
    }
}

