/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.util;

import io.apicurio.registry.rest.beans.SearchedArtifact;
import io.apicurio.registry.rest.beans.SearchedVersion;
import io.apicurio.registry.rest.beans.SortOrder;
import io.apicurio.registry.storage.ArtifactMetaDataDto;
import io.apicurio.registry.storage.ArtifactVersionMetaDataDto;
import java.util.Comparator;

public class SearchUtil {
    public static Comparator<String> comparator(SortOrder sortOrder) {
        return (id1, id2) -> SearchUtil.compare(sortOrder, id1, id2);
    }

    public static int compare(SortOrder sortOrder, String id1, String id2) {
        switch (sortOrder) {
            case desc: {
                return id2.compareToIgnoreCase(id1);
            }
        }
        return id1.compareToIgnoreCase(id2);
    }

    public static SearchedArtifact buildSearchedArtifact(ArtifactMetaDataDto artifactMetaData) {
        SearchedArtifact searchedArtifact = new SearchedArtifact();
        searchedArtifact.setId(artifactMetaData.getId());
        searchedArtifact.setName(artifactMetaData.getName());
        searchedArtifact.setState(artifactMetaData.getState());
        searchedArtifact.setDescription(artifactMetaData.getDescription());
        searchedArtifact.setCreatedOn(artifactMetaData.getCreatedOn());
        searchedArtifact.setCreatedBy(artifactMetaData.getCreatedBy());
        searchedArtifact.setModifiedBy(artifactMetaData.getModifiedBy());
        searchedArtifact.setModifiedOn(artifactMetaData.getModifiedOn());
        searchedArtifact.setType(artifactMetaData.getType());
        searchedArtifact.setLabels(artifactMetaData.getLabels());
        return searchedArtifact;
    }

    public static SearchedVersion buildSearchedVersion(ArtifactVersionMetaDataDto artifactVersionMetaData) {
        SearchedVersion searchedVersion = new SearchedVersion();
        searchedVersion.setCreatedBy(artifactVersionMetaData.getCreatedBy());
        searchedVersion.setCreatedOn(artifactVersionMetaData.getCreatedOn());
        searchedVersion.setDescription(artifactVersionMetaData.getDescription());
        searchedVersion.setGlobalId(artifactVersionMetaData.getGlobalId());
        searchedVersion.setName(artifactVersionMetaData.getName());
        searchedVersion.setState(artifactVersionMetaData.getState());
        searchedVersion.setType(artifactVersionMetaData.getType());
        searchedVersion.setVersion(artifactVersionMetaData.getVersion());
        return searchedVersion;
    }
}

