/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.converter;

import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.serde.AbstractKafkaSerDe;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.storage.Converter;

public class SchemalessConverter<T>
extends AbstractKafkaSerDe<SchemalessConverter<T>>
implements Converter {
    public static final String REGISTRY_CONVERTER_SERIALIZER_PARAM = "apicurio.registry.converter.serializer";
    public static final String REGISTRY_CONVERTER_DESERIALIZER_PARAM = "apicurio.registry.converter.deserializer";
    protected Serializer<T> serializer;
    private boolean createdSerializer;
    protected Deserializer<T> deserializer;
    private boolean createdDeserializer;

    public SchemalessConverter() {
    }

    public SchemalessConverter(Serde<T> serde) {
        this(Objects.requireNonNull(serde).serializer(), Objects.requireNonNull(serde).deserializer());
    }

    public SchemalessConverter(Serializer<T> serializer, Deserializer<T> deserializer) {
        this.setSerializer(serializer);
        this.setDeserializer(deserializer);
    }

    protected Class<? extends Serializer> serializerClass() {
        return Serializer.class;
    }

    protected Class<? extends Deserializer> deserializerClass() {
        return Deserializer.class;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        if (this.serializer == null) {
            Object sp = configs.get(REGISTRY_CONVERTER_SERIALIZER_PARAM);
            this.instantiate(this.serializerClass(), sp, this::setSerializer);
            this.serializer.configure(configs, isKey);
            this.createdSerializer = true;
        }
        if (this.deserializer == null) {
            Object dsp = configs.get(REGISTRY_CONVERTER_DESERIALIZER_PARAM);
            this.instantiate(this.deserializerClass(), dsp, this::setDeserializer);
            this.deserializer.configure(configs, isKey);
            this.createdDeserializer = true;
        }
    }

    @Override
    public void close() {
        if (this.createdSerializer) {
            IoUtil.closeIgnore(this.serializer);
        }
        if (this.createdDeserializer) {
            IoUtil.closeIgnore(this.deserializer);
        }
        super.close();
    }

    protected T applySchema(Schema schema, Object value) {
        return (T)value;
    }

    public byte[] fromConnectData(String topic, Schema schema, Object value) {
        return this.serializer.serialize(topic, this.applySchema(schema, value));
    }

    protected Schema provideSchema(T result) {
        return null;
    }

    protected SchemaAndValue toSchemaAndValue(T result) {
        return new SchemaAndValue(this.provideSchema(result), result);
    }

    public SchemaAndValue toConnectData(String topic, byte[] bytes) {
        Object result = this.deserializer.deserialize(topic, bytes);
        if (result == null) {
            return SchemaAndValue.NULL;
        }
        return this.toSchemaAndValue(result);
    }

    public void setSerializer(Serializer<T> serializer) {
        this.serializer = Objects.requireNonNull(serializer);
    }

    public void setDeserializer(Deserializer<T> deserializer) {
        this.deserializer = Objects.requireNonNull(deserializer);
    }
}

