/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.serde;

import com.fasterxml.jackson.core.JsonParser;
import com.worldturner.medeia.schema.validation.SchemaValidator;
import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.rest.beans.ArtifactMetaData;
import io.apicurio.registry.rest.beans.VersionMetaData;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.serde.JsonSchemaKafkaSerDe;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class JsonSchemaKafkaDeserializer<T>
extends JsonSchemaKafkaSerDe<JsonSchemaKafkaDeserializer<T>>
implements Deserializer<T> {
    public JsonSchemaKafkaDeserializer() {
        this(null, null);
    }

    public JsonSchemaKafkaDeserializer(RegistryService client, Boolean validationEnabled) {
        super(client, validationEnabled);
    }

    public T deserialize(String topic, byte[] data) {
        throw new UnsupportedOperationException();
    }

    public T deserialize(String topic, Headers headers, byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            JsonParser parser = mapper.getFactory().createParser(data);
            if (this.isValidationEnabled()) {
                Long globalId = this.getGlobalId(headers);
                if (globalId == null) {
                    String artifactId = this.getArtifactId(headers);
                    Integer version = this.getVersion(headers);
                    globalId = this.toGlobalId(artifactId, version);
                }
                SchemaValidator schema = this.getSchemaCache().getSchema(globalId);
                parser = api.decorateJsonParser(schema, parser);
            }
            Class<T> messageType = this.getMessageType(headers);
            return (T)mapper.readValue(parser, messageType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected Long getGlobalId(Headers headers) {
        Header header = headers.lastHeader("apicurio.globalId");
        if (header == null) {
            return null;
        }
        return ByteBuffer.wrap(header.value()).getLong();
    }

    protected String getArtifactId(Headers headers) {
        Header header = headers.lastHeader("apicurio.artifactId");
        if (header == null) {
            throw new RuntimeException("ArtifactId not found in headers.");
        }
        return IoUtil.toString(header.value());
    }

    protected Integer getVersion(Headers headers) {
        Header header = headers.lastHeader("apicurio.version");
        if (header == null) {
            return null;
        }
        return ByteBuffer.wrap(header.value()).getInt();
    }

    protected Class<T> getMessageType(Headers headers) {
        Header header = headers.lastHeader("apicurio.messageType");
        if (header == null) {
            throw new RuntimeException("Message Type not found in headers.");
        }
        String msgTypeName = IoUtil.toString(header.value());
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(msgTypeName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName(msgTypeName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected Long toGlobalId(String artifactId, Integer version) {
        if (version == null) {
            ArtifactMetaData amd = this.getClient().getArtifactMetaData(artifactId);
            return amd.getGlobalId();
        }
        VersionMetaData vmd = this.getClient().getArtifactVersionMetaData(version, artifactId);
        return vmd.getGlobalId();
    }
}

