/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.serde;

import com.fasterxml.jackson.core.JsonGenerator;
import com.worldturner.medeia.schema.validation.SchemaValidator;
import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.serde.JsonSchemaKafkaSerDe;
import io.apicurio.registry.utils.serde.strategy.FindLatestIdStrategy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;

public class JsonSchemaKafkaSerializer<T>
extends JsonSchemaKafkaSerDe<JsonSchemaKafkaSerializer<T>>
implements Serializer<T> {
    public JsonSchemaKafkaSerializer() {
        this(null, null);
    }

    public JsonSchemaKafkaSerializer(RegistryService client, Boolean validationEnabled) {
        super(client, validationEnabled);
        this.setGlobalIdStrategy(new FindLatestIdStrategy());
    }

    public byte[] serialize(String topic, T data) {
        throw new UnsupportedOperationException();
    }

    public byte[] serialize(String topic, Headers headers, T data) {
        if (data == null) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonGenerator generator = mapper.getFactory().createGenerator((OutputStream)baos);
            if (this.isValidationEnabled()) {
                String artifactId = this.getArtifactId(topic, data);
                long globalId = this.getGlobalId(artifactId, topic, data);
                this.addSchemaHeaders(headers, artifactId, globalId);
                SchemaValidator schemaValidator = this.getSchemaCache().getSchema(globalId);
                generator = api.decorateJsonGenerator(schemaValidator, generator);
            }
            this.addTypeHeaders(headers, data);
            mapper.writeValue(generator, data);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected String getArtifactId(String topic, T data) {
        return this.getArtifactIdStrategy().artifactId(topic, this.isKey(), null);
    }

    protected long getGlobalId(String artifactId, String topic, T data) {
        return this.getGlobalIdStrategy().findId(this.getClient(), artifactId, ArtifactType.JSON, null);
    }

    protected void addSchemaHeaders(Headers headers, String artifactId, long globalId) {
        if (globalId >= 0L) {
            ByteBuffer buff = ByteBuffer.allocate(8);
            buff.putLong(globalId);
            headers.add("apicurio.globalId", buff.array());
        } else {
            headers.add("apicurio.artifactId", IoUtil.toBytes(artifactId));
        }
    }

    protected void addTypeHeaders(Headers headers, T data) {
        headers.add("apicurio.messageType", IoUtil.toBytes(data.getClass().getName()));
    }
}

