/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.serde;

import io.apicurio.registry.client.RegistryService;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.Response;

public abstract class SchemaCache<T> {
    private final RegistryService client;
    private final Map<Long, T> schemas = new ConcurrentHashMap<Long, T>();

    public SchemaCache(RegistryService client) {
        this.client = Objects.requireNonNull(client);
    }

    protected abstract T toSchema(Response var1);

    public T getSchema(long id) {
        return (T)this.schemas.computeIfAbsent(id, key -> {
            Response artifactResponse = this.client.getArtifactByGlobalId((long)key);
            Response.StatusType statusInfo = artifactResponse.getStatusInfo();
            if (statusInfo.getStatusCode() != 200) {
                throw new IllegalStateException(String.format("Error [%s] retrieving schema: %s", statusInfo.getReasonPhrase(), key));
            }
            return this.toSchema(artifactResponse);
        });
    }

    public void clear() {
        this.schemas.clear();
    }
}

