/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.serde.strategy;

import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.rest.beans.ArtifactMetaData;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.serde.strategy.AbstractCrudIdStrategy;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CachedSchemaIdStrategy<T>
extends AbstractCrudIdStrategy<T> {
    private Map<String, Long> cache = new ConcurrentHashMap<String, Long>();

    @Override
    protected long initialLookup(RegistryService service, String artifactId, ArtifactType artifactType, T schema) {
        InputStream stream = this.toStream(schema);
        String content = IoUtil.toString(stream);
        return this.cache.computeIfAbsent(content, k -> service.getArtifactMetaDataByContent(artifactId, this.toStream(schema)).getGlobalId());
    }

    @Override
    protected void afterCreateArtifact(T schema, ArtifactMetaData amd) {
        InputStream stream = this.toStream(schema);
        String content = IoUtil.toString(stream);
        this.cache.put(content, amd.getGlobalId());
    }
}

