/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.utils.tests.TestUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;

public abstract class AbstractRegistryTestBase {
    protected String generateArtifactId() {
        return TestUtils.generateArtifactId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final String resourceToString(String resourceName) {
        try (InputStream stream = this.getClass().getResourceAsStream(resourceName);){
            Assertions.assertNotNull((Object)stream, (String)("Resource not found: " + resourceName));
            String string = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final ContentHandle resourceToContentHandle(String resourceName) {
        return ContentHandle.create((String)this.resourceToString(resourceName));
    }
}

