/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry;

import io.apicurio.registry.AbstractRegistryTestBase;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.util.ServiceInitializer;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;

public abstract class AbstractResourceTestBase
extends AbstractRegistryTestBase {
    protected static final String CT_JSON = "application/json";
    protected static final String CT_PROTO = "application/x-protobuf";
    protected static final String CT_YAML = "application/x-yaml";
    protected static final String CT_XML = "application/xml";
    @Inject
    Instance<ServiceInitializer> initializers;

    @BeforeEach
    protected void beforeEach() {
        RestAssured.baseURI = "http://localhost:8081/api";
        this.initializers.stream().forEach(ServiceInitializer::beforeEach);
        ((ValidatableResponse)((Response)RestAssured.given().when().delete("/rules", new Object[0])).then()).statusCode(204);
    }

    protected void createArtifact(String artifactId, ArtifactType artifactType, String artifactContent) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType(CT_JSON).header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).header("X-Registry-ArtifactType", (Object)artifactType.name(), new Object[0]).body(artifactContent).post("/artifacts", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)artifactId), new Object[0])).body("type", Matchers.equalTo((Object)artifactType.name()), new Object[0]);
    }
}

