/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.rest.beans.ArtifactMetaData;
import io.apicurio.registry.rest.beans.EditableMetaData;
import io.apicurio.registry.rest.beans.UpdateState;
import io.apicurio.registry.rest.beans.VersionMetaData;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.utils.ConcurrentUtil;
import io.apicurio.registry.utils.tests.RegistryServiceTest;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import javax.ws.rs.core.Response;
import org.junit.jupiter.api.Assertions;

@QuarkusTest
public class ArtifactStateTest
extends AbstractResourceTestBase {
    private static final UpdateState toUpdateState(ArtifactState state) {
        UpdateState us = new UpdateState();
        us.setState(state);
        return us;
    }

    @RegistryServiceTest
    public void testSmoke(Supplier<RegistryService> supplier) throws Exception {
        RegistryService service = supplier.get();
        String artifactId = this.generateArtifactId();
        CompletionStage a1 = service.createArtifact(ArtifactType.JSON, artifactId, null, (InputStream)new ByteArrayInputStream("{\"type\": \"string\"}".getBytes(StandardCharsets.UTF_8)));
        ConcurrentUtil.result((CompletionStage)a1);
        CompletionStage a2 = service.updateArtifact(artifactId, ArtifactType.JSON, (InputStream)new ByteArrayInputStream("\"type\": \"int\"".getBytes(StandardCharsets.UTF_8)));
        ConcurrentUtil.result((CompletionStage)a2);
        CompletionStage a3 = service.updateArtifact(artifactId, ArtifactType.JSON, (InputStream)new ByteArrayInputStream("\"type\": \"float\"".getBytes(StandardCharsets.UTF_8)));
        ConcurrentUtil.result((CompletionStage)a3);
        ArtifactMetaData amd = service.getArtifactMetaData(artifactId);
        Assertions.assertEquals((int)3, (Integer)amd.getVersion());
        service.updateArtifactState(artifactId, ArtifactStateTest.toUpdateState(ArtifactState.DISABLED));
        TestUtils.retry(() -> {
            VersionMetaData tvmd = service.getArtifactVersionMetaData(Integer.valueOf(3), artifactId);
            Assertions.assertEquals((int)3, (Integer)tvmd.getVersion());
            Assertions.assertEquals((Object)ArtifactState.DISABLED, (Object)tvmd.getState());
            return null;
        });
        TestUtils.retry(() -> {
            ArtifactMetaData tamd = service.getArtifactMetaData(artifactId);
            Assertions.assertEquals((int)2, (Integer)tamd.getVersion());
            Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)tamd.getState());
            Assertions.assertNull((Object)tamd.getDescription());
            return null;
        });
        EditableMetaData emd = new EditableMetaData();
        String description = "Testing artifact state";
        emd.setDescription(description);
        TestUtils.assertWebError((int)400, () -> service.getArtifactVersion(Integer.valueOf(3), artifactId));
        TestUtils.assertWebError((int)400, () -> service.updateArtifactVersionMetaData(Integer.valueOf(3), artifactId, emd));
        service.updateArtifactMetaData(artifactId, emd);
        TestUtils.retry(() -> {
            ArtifactMetaData tamd = service.getArtifactMetaData(artifactId);
            Assertions.assertEquals((int)2, (Integer)tamd.getVersion());
            Assertions.assertEquals((Object)description, (Object)tamd.getDescription());
            return null;
        });
        service.updateArtifactVersionState(Integer.valueOf(3), artifactId, ArtifactStateTest.toUpdateState(ArtifactState.DEPRECATED));
        TestUtils.retry(() -> {
            ArtifactMetaData tamd = service.getArtifactMetaData(artifactId);
            Assertions.assertEquals((int)3, (Integer)tamd.getVersion());
            Assertions.assertEquals((Object)ArtifactState.DEPRECATED, (Object)tamd.getState());
            Assertions.assertNull((Object)tamd.getDescription());
            Response avr = service.getLatestArtifact(artifactId);
            Assertions.assertEquals((int)200, (int)avr.getStatus());
            avr = service.getArtifactVersion(Integer.valueOf(2), artifactId);
            Assertions.assertEquals((int)200, (int)avr.getStatus());
            TestUtils.assertWebError((int)400, () -> service.updateArtifactState(artifactId, ArtifactStateTest.toUpdateState(ArtifactState.ENABLED)));
            return null;
        });
        service.updateArtifactMetaData(artifactId, emd);
        TestUtils.retry(() -> {
            ArtifactMetaData tamd = service.getArtifactMetaData(artifactId);
            Assertions.assertEquals((int)3, (Integer)tamd.getVersion());
            Assertions.assertEquals((Object)description, (Object)tamd.getDescription());
            VersionMetaData tvmd = service.getArtifactVersionMetaData(Integer.valueOf(1), artifactId);
            Assertions.assertNull((Object)tvmd.getDescription());
            return null;
        });
        service.updateArtifactState(artifactId, ArtifactStateTest.toUpdateState(ArtifactState.DELETED));
        TestUtils.retry(() -> {
            ArtifactMetaData tamd = service.getArtifactMetaData(artifactId);
            Assertions.assertEquals((int)2, (Integer)tamd.getVersion());
            Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)tamd.getState());
            return null;
        });
    }

    @RegistryServiceTest
    void testEnableDisableArtifact(Supplier<RegistryService> supplier) throws Exception {
        RegistryService service = supplier.get();
        String artifactId = this.generateArtifactId();
        CompletionStage a1 = service.createArtifact(ArtifactType.JSON, artifactId, null, (InputStream)new ByteArrayInputStream("{\"type\": \"string\"}".getBytes(StandardCharsets.UTF_8)));
        ArtifactMetaData md = (ArtifactMetaData)ConcurrentUtil.result((CompletionStage)a1);
        TestUtils.retry(() -> {
            ArtifactMetaData actualMD = service.getArtifactMetaData(artifactId);
            Assertions.assertEquals((Long)md.getGlobalId(), (Long)actualMD.getGlobalId());
        });
        UpdateState state = new UpdateState();
        state.setState(ArtifactState.DISABLED);
        service.updateArtifactState(artifactId, state);
        TestUtils.assertWebError((int)404, () -> service.getArtifactMetaData(artifactId), (boolean)true);
        TestUtils.retry(() -> {
            VersionMetaData vmd = service.getArtifactVersionMetaData(md.getVersion(), artifactId);
            Assertions.assertEquals((Object)ArtifactState.DISABLED, (Object)vmd.getState());
        });
        state.setState(ArtifactState.ENABLED);
        service.updateArtifactState(artifactId, state);
        TestUtils.retry(() -> {
            ArtifactMetaData amd = service.getArtifactMetaData(artifactId);
            Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)amd.getState());
            VersionMetaData vmd = service.getArtifactVersionMetaData(md.getVersion(), artifactId);
            Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)vmd.getState());
        });
    }
}

