/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry;

import io.apicurio.registry.AbstractRegistryTestBase;
import io.apicurio.registry.rules.compatibility.CompatibilityChecker;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import io.quarkus.test.junit.QuarkusTest;
import java.util.Collections;
import javax.inject.Inject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class ArtifactTypeTest
extends AbstractRegistryTestBase {
    @Inject
    ArtifactTypeUtilProviderFactory factory;

    @Test
    public void testAvro() {
        String avroString = "{\"type\":\"record\",\"name\":\"myrecord1\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}]}";
        ArtifactType avro = ArtifactType.AVRO;
        ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(avro);
        CompatibilityChecker checker = provider.getCompatibilityChecker();
        Assertions.assertTrue((boolean)checker.isCompatibleWith(CompatibilityLevel.BACKWARD, Collections.emptyList(), avroString));
        String avroString2 = "{\"type\":\"record\",\"name\":\"myrecord1\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\", \"qq\":\"ff\"}]}";
        Assertions.assertTrue((boolean)checker.isCompatibleWith(CompatibilityLevel.BACKWARD, Collections.singletonList(avroString), avroString2));
    }

    @Test
    public void testJson() {
        String jsonString = "{\"name\":\"foobar\"}";
        ArtifactType json = ArtifactType.JSON;
        ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(json);
        CompatibilityChecker checker = provider.getCompatibilityChecker();
        Assertions.assertTrue((boolean)checker.isCompatibleWith(CompatibilityLevel.BACKWARD, Collections.emptyList(), jsonString));
        Assertions.assertTrue((boolean)checker.isCompatibleWith(CompatibilityLevel.BACKWARD, Collections.singletonList(jsonString), jsonString));
    }

    @Test
    public void testProtobuf() {
        String data = "syntax = \"proto3\";\npackage test;\n\nmessage Channel {\n  int64 id = 1;\n  string name = 2;\n  string description = 3;\n}\n\nmessage NextRequest {}\nmessage PreviousRequest {}\n\nservice ChannelChanger {\n\trpc Next(stream NextRequest) returns (Channel);\n\trpc Previous(PreviousRequest) returns (stream Channel);\n}\n";
        ArtifactType protobuf = ArtifactType.PROTOBUF;
        ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(protobuf);
        CompatibilityChecker checker = provider.getCompatibilityChecker();
        Assertions.assertTrue((boolean)checker.isCompatibleWith(CompatibilityLevel.BACKWARD, Collections.emptyList(), data));
        String data2 = "syntax = \"proto3\";\npackage test;\n\nmessage Channel {\n  int64 id = 1;\n  string name = 2;\n  string description = 3;\n  string newff = 4;\n}\n\nmessage NextRequest {}\nmessage PreviousRequest {}\n\nservice ChannelChanger {\n\trpc Next(stream NextRequest) returns (Channel);\n\trpc Previous(PreviousRequest) returns (stream Channel);\n}\n";
        Assertions.assertTrue((boolean)checker.isCompatibleWith(CompatibilityLevel.BACKWARD, Collections.singletonList(data), data2));
        String data3 = "syntax = \"proto3\";\npackage test;\n\nmessage Channel {\n  int64 id = 1;\n  string name = 2;\n  string description = 4;\n}\n\nmessage NextRequest {}\nmessage PreviousRequest {}\n\nservice ChannelChanger {\n\trpc Next(stream NextRequest) returns (Channel);\n\trpc Previous(PreviousRequest) returns (stream Channel);\n}\n";
        Assertions.assertFalse((boolean)checker.isCompatibleWith(CompatibilityLevel.BACKWARD, Collections.singletonList(data), data3));
    }
}

