/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry;

import com.google.protobuf.Message;
import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.ccompat.dto.SchemaContent;
import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.rest.beans.Rule;
import io.apicurio.registry.support.HealthUtils;
import io.apicurio.registry.support.TestCmmn;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.tests.RegistryServiceTest;
import io.apicurio.registry.utils.tests.TestUtils;
import io.confluent.connect.avro.AvroConverter;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaDeserializer;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaSerializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufDeserializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializer;
import io.quarkus.test.junit.QuarkusTest;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class ConfluentClientTest
extends AbstractResourceTestBase {
    private SchemaRegistryClient buildClient() {
        List<SchemaProvider> schemaProviders = Arrays.asList(new JsonSchemaProvider(), new AvroSchemaProvider(), new ProtobufSchemaProvider());
        return new CachedSchemaRegistryClient(new RestService("http://localhost:8081/api/ccompat"), 3, schemaProviders, null, null);
    }

    @Test
    public void testSmoke() throws Exception {
        SchemaRegistryClient client = this.buildClient();
        Collection subjects = client.getAllSubjects();
        Assertions.assertNotNull((Object)subjects);
    }

    @Test
    public void testSimpleOps() throws Exception {
        SchemaRegistryClient client = this.buildClient();
        String subject = this.generateArtifactId();
        Schema schema1 = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"myrecord1\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}]}");
        int id1 = client.register(subject, schema1);
        Schema schema2 = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"myrecord2\",\"fields\":[{\"name\":\"f2\",\"type\":\"string\"}]}");
        int id2 = client.register(subject, schema2);
        Schema schema = client.getById(id1);
        Assertions.assertNotNull((Object)schema);
        client.reset();
        Assertions.assertTrue((boolean)client.testCompatibility(subject, schema2));
        TestUtils.retry(() -> {
            Schema schema3 = client.getById(id2);
            Assertions.assertNotNull((Object)schema3);
            return schema3;
        });
        Collection subjects = client.getAllSubjects();
        Assertions.assertTrue((boolean)subjects.contains(subject));
        List versions = client.getAllVersions(subject);
        Assertions.assertTrue((boolean)versions.contains(1));
        Assertions.assertTrue((boolean)versions.contains(2));
        int v2 = client.getVersion(subject, schema2);
        Assertions.assertEquals((int)2, (int)v2);
        int d1 = client.deleteSchemaVersion(subject, "1");
        Assertions.assertEquals((int)1, (int)d1);
        int d2 = client.deleteSchemaVersion(subject, "2");
        Assertions.assertEquals((int)2, (int)d2);
    }

    @Test
    public void testSerdeAvro() throws Exception {
        SchemaRegistryClient client = this.buildClient();
        String subject = this.generateArtifactId();
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"myrecord3\",\"fields\":[{\"name\":\"bar\",\"type\":\"string\"}]}");
        int id = client.register(subject + "-value", schema);
        client.reset();
        TestUtils.retry(() -> {
            Schema schema2 = client.getById(id);
            Assertions.assertNotNull((Object)schema2);
            return schema2;
        });
        try (KafkaAvroSerializer serializer = new KafkaAvroSerializer(client);
             KafkaAvroDeserializer deserializer = new KafkaAvroDeserializer(client);){
            GenericData.Record record = new GenericData.Record(schema);
            record.put("bar", (Object)"somebar");
            byte[] bytes = serializer.serialize(subject, (Object)record);
            GenericData.Record ir = (GenericData.Record)deserializer.deserialize(subject, bytes);
            Assertions.assertEquals((Object)"somebar", (Object)ir.get("bar").toString());
        }
    }

    @Test
    public void testSerdeJsonSchema() throws Exception {
        SchemaRegistryClient client = this.buildClient();
        String subject = this.generateArtifactId();
        SchemaContent schemaContent = new SchemaContent("{\"type\":\"record\",\"name\":\"myrecord1\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}]}", "JSON");
        Properties config = new Properties();
        config.put("auto.register.schemas", (Object)true);
        config.put("schema.registry.url", "http://localhost:8081/api/ccompat");
        try (KafkaJsonSchemaSerializer serializer = new KafkaJsonSchemaSerializer(client, new HashMap<Object, Object>(config));
             KafkaJsonSchemaDeserializer deserializer = new KafkaJsonSchemaDeserializer(client, (Map)config, SchemaContent.class);){
            byte[] bytes = serializer.serialize(subject, (Object)schemaContent);
            Object deserialized = deserializer.deserialize(subject, bytes);
            Assertions.assertEquals((Object)schemaContent, (Object)deserialized);
        }
    }

    @Test
    public void testSerdeProtobufSchema() throws Exception {
        TestCmmn.UUID record = TestCmmn.UUID.newBuilder().setLsb(2L).setMsb(1L).build();
        SchemaRegistryClient client = this.buildClient();
        String subject = this.generateArtifactId();
        Properties config = new Properties();
        config.put("auto.register.schemas", (Object)true);
        config.put("schema.registry.url", "http://localhost:8081/api/ccompat");
        try (KafkaProtobufSerializer serializer = new KafkaProtobufSerializer(client, new HashMap<Object, Object>(config));
             KafkaProtobufDeserializer deserializer = new KafkaProtobufDeserializer(client, (Map)config);){
            byte[] bytes = serializer.serialize(subject, (Message)record);
            Message deserialized = deserializer.deserialize(subject, bytes);
            Assertions.assertEquals((Object)record, (Object)deserialized);
        }
    }

    @Test
    public void testDelete() throws Exception {
        SchemaRegistryClient client = this.buildClient();
        String nonExisting = this.generateArtifactId();
        try {
            client.deleteSubject(nonExisting);
            Assertions.fail();
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)404, (int)e.getStatus());
        }
        TestUtils.retry(() -> {
            HealthUtils.assertIsReady();
            HealthUtils.assertIsLive();
        });
        String subject = this.generateArtifactId();
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"myrecord3\",\"fields\":[{\"name\":\"bar\",\"type\":\"string\"}]}");
        int id = client.register(subject, schema);
        client.reset();
        TestUtils.retry(() -> {
            Schema schema2 = client.getById(id);
            Assertions.assertNotNull((Object)schema2);
            return schema2;
        });
        Collection subjects = client.getAllSubjects();
        Assertions.assertTrue((boolean)subjects.contains(subject));
        client.deleteSubject(subject);
        TestUtils.retry(() -> {
            Collection all = client.getAllSubjects();
            Assertions.assertFalse((boolean)all.contains(subject));
            return null;
        });
    }

    @RegistryServiceTest
    public void testGlobalRule(Supplier<RegistryService> supplier) throws Exception {
        SchemaRegistryClient client = this.buildClient();
        RegistryService apicurioClient = supplier.get();
        Rule rule = new Rule();
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig("BACKWARD");
        apicurioClient.createGlobalRule(rule);
        String subject = this.generateArtifactId();
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"myrecord3\",\"fields\":[{\"name\":\"bar\",\"type\":\"string\"}]}");
        int id = client.register(subject, schema);
        client.reset();
        TestUtils.retry(() -> {
            Schema schema2 = client.getById(id);
            Assertions.assertNotNull((Object)schema2);
            return schema2;
        });
        Assertions.assertThrows(RestClientException.class, () -> {
            Schema schema2 = new Schema.Parser().parse("{\"type\":\"string\"}");
            client.register(subject, schema2);
            client.reset();
        });
    }

    @Test
    public void testConverter_PreRegisterSchema() {
        String subject = this.generateArtifactId();
        String name = "myr" + ThreadLocalRandom.current().nextInt(0, Integer.MAX_VALUE);
        this.testConverter(subject, name, false, client -> {
            try {
                Schema schema = new Schema.Parser().parse(String.format("{\"type\":\"record\",\"name\":\"%s\",\"fields\":[{\"name\":\"bar\",\"type\":\"string\"}],\"connect.name\":\"%s\"}", name, name));
                int id = client.register(subject + "-value", schema);
                client.reset();
                Schema retry = (Schema)TestUtils.retry(() -> client.getById(id));
                Assertions.assertNotNull((Object)retry);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }, (c, b) -> {});
    }

    @Test
    public void testConverter_AutoRegisterSchema() {
        String name = "myr" + ThreadLocalRandom.current().nextInt(0, Integer.MAX_VALUE);
        this.testConverter(this.generateArtifactId(), name, true, c -> {}, (client, bytes) -> {
            try {
                client.reset();
                Schema retry = (Schema)TestUtils.retry(() -> {
                    ByteBuffer buffer = ByteBuffer.wrap(bytes);
                    buffer.get();
                    int id = buffer.getInt();
                    return client.getById(id);
                });
                Assertions.assertNotNull((Object)retry);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }

    private void testConverter(String subject, String name, boolean autoRegister, Consumer<SchemaRegistryClient> pre, BiConsumer<SchemaRegistryClient, byte[]> post) {
        SchemaRegistryClient client = this.buildClient();
        pre.accept(client);
        SchemaBuilder cs = SchemaBuilder.struct().name(name).field("bar", org.apache.kafka.connect.data.Schema.STRING_SCHEMA);
        Struct struct = new Struct((org.apache.kafka.connect.data.Schema)cs);
        struct.put("bar", (Object)"somebar");
        AvroConverter converter = new AvroConverter(client);
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("schema.registry.url", "dummy");
        config.put("auto.register.schemas", autoRegister);
        converter.configure(config, false);
        byte[] bytes = converter.fromConnectData(subject, (org.apache.kafka.connect.data.Schema)cs, (Object)struct);
        post.accept(client, bytes);
        SchemaAndValue sav = converter.toConnectData(subject, bytes);
        Struct ir = (Struct)sav.value();
        Assertions.assertEquals((Object)"somebar", (Object)ir.get("bar").toString());
    }
}

