/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.beans.UpdateState;
import io.apicurio.registry.types.ArtifactState;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class ConfluentCompatApiTest
extends AbstractResourceTestBase {
    private static final String SCHEMA_SIMPLE = "{\"type\": \"string\"}";
    private static final String SCHEMA_SIMPLE_WRAPPED = "{\"schema\":\"{\\\"type\\\": \\\"string\\\"}\"}";
    private static final String SCHEMA_INVALID_WRAPPED = "{\"schema\":\"{\\\"type\\\": \\\"bloop\\\"}\"}";
    private static final String SCHEMA_1_WRAPPED = "{\"schema\": \"{\\\"type\\\": \\\"record\\\", \\\"name\\\": \\\"test1\\\", \\\"fields\\\": [ {\\\"type\\\": \\\"string\\\", \\\"name\\\": \\\"field1\\\"} ] }\"}\"";
    private static final String SCHEMA_2_WRAPPED = "{\"schema\": \"{\\\"type\\\": \\\"record\\\", \\\"name\\\": \\\"test1\\\", \\\"fields\\\": [ {\\\"type\\\": \\\"string\\\", \\\"name\\\": \\\"field1\\\"}, {\\\"type\\\": \\\"string\\\", \\\"name\\\": \\\"field2\\\"} ] }\"}\"";
    private static final String CONFIG_BACKWARD = "{\"compatibility\": \"BACKWARD\"}";

    @Test
    public void testCreateSubject() {
        String SUBJECT = "subject1";
        ValidatableResponse res = (ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/vnd.schemaregistry+json").body(SCHEMA_SIMPLE_WRAPPED).post("/ccompat/subjects/{subject}/versions", new Object[]{"subject1"})).then()).statusCode(200)).body("id", Matchers.allOf((Matcher)Matchers.isA(Integer.class), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0))), new Object[0]);
        res.extract().jsonPath().getInt("id");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/artifacts/{artifactId}", new Object[]{"subject1"})).then()).statusCode(200)).body("", Matchers.equalTo((Object)new JsonPath(SCHEMA_SIMPLE).getMap("")), new Object[0]);
    }

    @Test
    public void testCompatibilityCheck() {
        String SUBJECT = "subject2";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/vnd.schemaregistry+json").body(SCHEMA_2_WRAPPED).post("/ccompat/subjects/{subject}/versions", new Object[]{"subject2"})).then()).statusCode(200)).body(Matchers.anything(), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/vnd.schemaregistry+json").body(CONFIG_BACKWARD).put("/ccompat/config/{subject}", new Object[]{"subject2"})).then()).statusCode(200)).body(Matchers.anything(), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/vnd.schemaregistry+json").body(SCHEMA_1_WRAPPED).post("/ccompat/compatibility/subjects/{subject}/versions/{version}", new Object[]{"subject2", "latest"})).then()).statusCode(200)).body("is_compatible", Matchers.equalTo((Object)true), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/vnd.schemaregistry+json").body(SCHEMA_SIMPLE_WRAPPED).post("/ccompat/compatibility/subjects/{subject}/versions/{version}", new Object[]{"subject2", "latest"})).then()).statusCode(200)).body("is_compatible", Matchers.equalTo((Object)false), new Object[0]);
    }

    @Test
    public void testDisabledStateCheck() {
        String SUBJECT = "subject3";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/vnd.schemaregistry+json").body(SCHEMA_SIMPLE_WRAPPED).post("/ccompat/subjects/{subject}/versions", new Object[]{"subject3"})).then()).statusCode(200)).body("id", Matchers.allOf((Matcher)Matchers.isA(Integer.class), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0))), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/artifacts/{artifactId}", new Object[]{"subject3"})).then()).statusCode(200)).body("", Matchers.equalTo((Object)new JsonPath(SCHEMA_SIMPLE).getMap("")), new Object[0]);
        UpdateState updateState = new UpdateState();
        updateState.setState(ArtifactState.DISABLED);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)updateState).put("/artifacts/{artifactId}/state", new Object[]{"subject3"})).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/vnd.schemaregistry+json").get("/ccompat/subjects/{subject}/versions/{version}", new Object[]{"subject3", "latest"})).then()).statusCode(400);
    }

    @Test
    public void testDeletedStateCheck() {
        String SUBJECT = "subject4";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/vnd.schemaregistry+json").body(SCHEMA_SIMPLE_WRAPPED).post("/ccompat/subjects/{subject}/versions", new Object[]{"subject4"})).then()).log().all()).statusCode(200)).body("id", Matchers.allOf((Matcher)Matchers.isA(Integer.class), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0))), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/artifacts/{artifactId}", new Object[]{"subject4"})).then()).statusCode(200)).body("", Matchers.equalTo((Object)new JsonPath(SCHEMA_SIMPLE).getMap("")), new Object[0]);
        UpdateState us = new UpdateState();
        us.setState(ArtifactState.DELETED);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)us).put("/artifacts/{artifactId}/state", new Object[]{"subject4"})).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/vnd.schemaregistry+json").get("/ccompat/subjects/{subject}/versions/{version}", new Object[]{"subject4", "latest"})).then()).statusCode(404);
    }

    @Test
    public void testSchemaTypes() {
        String[] types = (String[])((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/ccompat/schemas/types", new Object[0])).then()).statusCode(200)).extract().as(String[].class);
        Assertions.assertEquals((int)3, (int)types.length);
        Assertions.assertEquals((Object)"JSON", (Object)types[0]);
        Assertions.assertEquals((Object)"PROTOBUF", (Object)types[1]);
        Assertions.assertEquals((Object)"AVRO", (Object)types[2]);
    }

    @Test
    public void testGetSchemaVersions() {
        String SUBJECT = "subjectTestSchemaVersions";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/vnd.schemaregistry+json").body(SCHEMA_SIMPLE_WRAPPED).post("/ccompat/subjects/{subject}/versions", new Object[]{"subjectTestSchemaVersions"})).then()).statusCode(200)).body("id", Matchers.allOf((Matcher)Matchers.isA(Integer.class), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0))), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/vnd.schemaregistry+json").body(SCHEMA_SIMPLE_WRAPPED).post("/ccompat/subjects/{subject}/versions", new Object[]{"subjectTestSchemaVersions"})).then()).statusCode(200)).body("id", Matchers.allOf((Matcher)Matchers.isA(Integer.class), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))), new Object[0]);
        Integer globalId = (Integer)((Response)RestAssured.given().when().get("/ccompat/subjects/{subject}/versions/latest", new Object[]{"subjectTestSchemaVersions"})).body().jsonPath().get("id");
        Assertions.assertEquals(Arrays.asList(1, 2), (Object)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/vnd.schemaregistry+json").get("/ccompat/schemas/ids/{id}/versions", new Object[]{globalId})).then()).extract().body().jsonPath().get("version"));
    }

    @Test
    public void testGetSchemaReferencedVersions() {
        String SUBJECT = "testGetSchemaReferencedVersions";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/vnd.schemaregistry+json").body(SCHEMA_SIMPLE_WRAPPED).post("/ccompat/subjects/{subject}/versions", new Object[]{"testGetSchemaReferencedVersions"})).then()).statusCode(200)).body("id", Matchers.allOf((Matcher)Matchers.isA(Integer.class), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0))), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/vnd.schemaregistry+json").body(SCHEMA_SIMPLE_WRAPPED).post("/ccompat/subjects/{subject}/versions", new Object[]{"testGetSchemaReferencedVersions"})).then()).statusCode(200)).body("id", Matchers.allOf((Matcher)Matchers.isA(Integer.class), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))), new Object[0]);
        Integer[] versions = (Integer[])((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/ccompat/subjects/{subject}/versions/{version}/referencedby", new Object[]{"testGetSchemaReferencedVersions", 1L})).then()).statusCode(200)).extract().as(Integer[].class);
        Assertions.assertEquals((int)2, (int)versions.length);
    }
}

