/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.beans.Rule;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.RuleType;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.config.EncoderConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class FullApiTest
extends AbstractResourceTestBase {
    @Test
    public void testGlobalRuleApplicationOpenAPI() {
        ArtifactType artifactType = ArtifactType.OPENAPI;
        String artifactContent = this.resourceToString("openapi-invalid-syntax.json");
        this.createArtifact("testGlobalRuleApplicationOpenAPI/API", artifactType, artifactContent);
        Rule rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig(ValidityLevel.SYNTAX_ONLY.name());
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).post("/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        String artifactId = "testGlobalRuleApplicationOpenAPI/InvalidAPI";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).header("X-Registry-ArtifactType", (Object)artifactType.name(), new Object[0]).body(artifactContent).post("/artifacts", new Object[0])).then()).statusCode(400)).body("error_code", Matchers.equalTo((Object)400), new Object[0])).body("message", Matchers.equalTo((Object)"Syntax violation for OpenAPI artifact."), new Object[0]);
    }

    @Test
    public void testGlobalRuleApplicationProtobuf() {
        ArtifactType artifactType = ArtifactType.PROTOBUF;
        String artifactContent = this.resourceToString("protobuf-invalid-syntax.proto");
        this.createArtifact("testGlobalRuleApplicationProtobuf/API", artifactType, artifactContent);
        Rule rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig(ValidityLevel.SYNTAX_ONLY.name());
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).post("/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        String artifactId = "testGlobalRuleApplicationProtobuf/InvalidAPI";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().config(RestAssured.config().encoderConfig(new EncoderConfig().encodeContentTypeAs("application/x-protobuf", ContentType.TEXT))).when().contentType("application/x-protobuf").header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).header("X-Registry-ArtifactType", (Object)artifactType.name(), new Object[0]).body(artifactContent).post("/artifacts", new Object[0])).then()).statusCode(400)).body("error_code", Matchers.equalTo((Object)400), new Object[0])).body("message", Matchers.equalTo((Object)"Syntax violation for Protobuf artifact."), new Object[0]);
    }
}

