/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.json.JsonConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JsonConverterTest {
    @Test
    public void testOriginalJson() {
        this.testJson(true);
        this.testJson(false);
    }

    private void testJson(boolean enableSchemas) {
        JsonConverter converter = new JsonConverter();
        converter.configure(Collections.singletonMap("schemas.enable", enableSchemas), false);
        Schema sc = SchemaBuilder.struct().field("bar", Schema.STRING_SCHEMA).build();
        Struct struct = new Struct(sc);
        struct.put("bar", (Object)"somebar");
        byte[] bytes = converter.fromConnectData("qwerty123", sc, (Object)struct);
        Object result = converter.toConnectData("qwerty123", bytes).value();
        Object value = result instanceof Struct ? ((Struct)Struct.class.cast(result)).get("bar") : ((Map)Map.class.cast(result)).get("bar");
        Assertions.assertEquals((Object)"somebar", (Object)value.toString());
        converter.close();
    }
}

